package ch.sahits.game.openpatrician.display.event.task;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.PeopleFactory;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.people.INonFreeSeaPirate;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.factory.annotation.Autowired;

import java.time.LocalDateTime;

/**
 * Timed task to create a free priate.
 * Created by andi on 26.03.17.
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class FreePirateTimedTask extends TimedTask {
    @Autowired
    @XStreamOmitField
    private PeopleFactory peopleFactory;

    private INonFreeSeaPirate seaPirate;

    public FreePirateTimedTask(INonFreeSeaPirate seaPirate, LocalDateTime deadline) {
        this.seaPirate = seaPirate;
        setExecutionTime(deadline);
    }

    @Override
    public void run() {
        peopleFactory.free(seaPirate);
    }
}
