package ch.sahits.game.openpatrician.display.event.task;

import ch.sahits.game.openpatrician.display.event.data.DelayedTravelToEvent;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.OptionalType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import javafx.geometry.Point2D;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.annotation.PostConstruct;
import java.util.Optional;

/**
 * Timed task for delaysed travel to events triggered from the sea map.
 * Created by andi on 26.03.17.
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class TravelToTimedTask extends TimedTask {
    @Autowired
    private Date date;
    @Autowired
    @Qualifier("clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;

    private Point2D destination;
    private INavigableVessel vessel;
    @OptionalType(ICity.class)
    private Optional<ICity> city;

    public TravelToTimedTask(Point2D destination, INavigableVessel vessel, Optional<ICity> city) {
        this.destination = destination;
        this.vessel = vessel;
        this.city = city;
    }

    @PostConstruct
    private void init() {
        setExecutionTime(date.getCurrentDate().plusDays(5));
    }
    @Override
    public void run() {
        clientEventBus.post(new DelayedTravelToEvent(destination, vessel, city));
    }
}
