package ch.sahits.game.openpatrician.display.gameplay.impl;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

/**
 * Factory for retrieving the proper scene initializer for the current scene, to setup the polygons.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 13, 2013
 */
@Component
@Lazy
@DependentInitialisation(StartNewGameBean.class)
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class PolygonInitializerFactory {
    @ObjectPropertyType(EScene.class)
    private ObjectProperty<EScene> currentScene = new SimpleObjectProperty<>(this, "currentScene", EScene.PORT);
    @Autowired
    private PortScenePolygonInitializer portSceneInitializer;
    @Autowired
    private MarketScenePolygonInitializer marketSceneInitializer;
    @Autowired
    private ShipyardScenePolygonInitializer shipyardSceneInitializer;
    @Autowired
    private TavernScenePolygonInitializer tavernSceneInitializer;
    @Autowired
    private CityHallScenePolygonInitializer cityHallSceneInitializer;
    @Autowired
    private LoanerScenePolygonInitializer loanerSceneInitializer;
    @Autowired
    private ChurchScenePolygonInitializer churchSceneInitializer;
    @Autowired
    private GuildScenePolygonInitializer guildSceneInitializer;
    @Autowired
    private ArmoryPolygonInitializer armoryPolygonInitializer;


    public ObjectProperty<EScene> currentSceneProperty() {
        return currentScene;
    }

    public ScenePolygonInitialzer getScenePolygonInitializer() {
        switch (currentScene.get()) {
            case PORT:
                return portSceneInitializer;
            case MARKET:
                return marketSceneInitializer;
            case SHIPYARD:
                return shipyardSceneInitializer;
            case TAVERN:
                return tavernSceneInitializer;
            case CITY_HALL:
                return cityHallSceneInitializer;
            case LOANER:
                return loanerSceneInitializer;
            case CHURCH:
                 return churchSceneInitializer;
            case GUILD:
                return guildSceneInitializer;
            case ARMORY:
                return armoryPolygonInitializer;
            default:
                throw new IllegalStateException("Unsupported scene: "+currentScene.get());
        }
    }

}
