package ch.sahits.game.openpatrician.display.javafx.action;

import ch.sahits.game.openpatrician.clientserverinterface.service.TradeService;
import ch.sahits.game.openpatrician.display.dialog.service.ITransferableJFX;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.javafx.bindings.ConstantIntegerBinding;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ComputablePriceV2;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import com.google.common.base.Preconditions;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.util.Pair;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Map;
import java.util.Map.Entry;
import java.util.Optional;

/**
 * Action of buying stuff from the city onto the ship
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Nov 23, 2011
 *
 */
@Prototype
@ClassCategory({EClassCategory.HANDLER, EClassCategory.PROTOTYPE_BEAN})
class City2ShipJFXAction implements Runnable{
	private final IWare ware;
	private final ITransferableJFX transfer;

	@Autowired
	private TradeService tradeService;

	public City2ShipJFXAction(IWare ware, ITransferableJFX transfer) {
		super();
		this.ware = ware;
		this.transfer =transfer;
	}

	@Override
	public void run() {
		final ICity city = transfer.getCity();
		int availableAmountCity = city.getWare(ware).getAmount();
		if (availableAmountCity>0) {
			int amount2Move = transfer.getAmount(availableAmountCity); // This is ware specific size
			final IPlayer player = transfer.getPlayer();
			final INavigableVessel vessel = transfer.getVessel();
			final int capacity = vessel.getCapacity();
			amount2Move = Math.min(amount2Move, capacity);
			tradeService.buyFromCityToShip(vessel, player, city, ware, amount2Move, Optional.empty(), Optional.empty());
		} // end no ware available
	}
}
