package ch.sahits.game.openpatrician.display.javafx.action;

import ch.sahits.game.openpatrician.clientserverinterface.service.TradeService;
import ch.sahits.game.openpatrician.display.dialog.service.ITransferableJFX;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.javafx.bindings.ConstantIntegerBinding;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ETransferAmount;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import javafx.beans.property.SimpleIntegerProperty;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Map;
import java.util.Map.Entry;
import java.util.Optional;

/**
 * Action of selling stuff to the city from the ship
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Nov 23, 2011
 *
 */
@Prototype
@ClassCategory({EClassCategory.HANDLER, EClassCategory.PROTOTYPE_BEAN})
class Ship2CityJFXAction implements Runnable{
	private final IWare ware;
	private final ITransferableJFX transfer;
	@Autowired
	private TradeService tradeService;

	public Ship2CityJFXAction(IWare ware, ITransferableJFX transfer) {
		super();
		this.ware = ware;
		this.transfer=transfer;
	}

	@Override
	public void run() {
		final INavigableVessel vessel = transfer.getVessel();
		int amountOnShip = vessel.getWare(ware).getAmount();
		if (amountOnShip>0){
			final ICity city = transfer.getCity();
			int amount2Move = transfer.getAmount(amountOnShip);
			tradeService.sellWareShipToCity(vessel, transfer.getPlayer(), city, ware, amount2Move, Optional.empty());
		}
	}
}
