package ch.sahits.game.openpatrician.display.javafx.action;


import ch.sahits.game.openpatrician.clientserverinterface.service.TradeService;
import ch.sahits.game.openpatrician.display.dialog.service.ITransferableJFX;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Optional;






/**
 * This action handles the case of transfering wares from the ship into the storage
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 24, 2011
 *
 */
@Prototype
@ClassCategory({EClassCategory.HANDLER, EClassCategory.PROTOTYPE_BEAN})
class Ship2StorageJFXAction implements Runnable {
	private final IWare ware;
	private final ITransferableJFX transfer;
	@Autowired
	private TradeService tradeService;


	public Ship2StorageJFXAction(IWare ware, ITransferableJFX transfer) {
		super();
		this.ware = ware;
		this.transfer=transfer;
	}

	@Override
	public void run() {
		INavigableVessel ship = transfer.getVessel();
		final AmountablePrice<IWare> amountable = ship.getWare(this.ware);
		int availableAmountShip = amountable.getAmount();
		final IPlayer player = transfer.getPlayer();
		ICity city = transfer.getCity();
		Optional<ITradingOffice> optOffice = player.findTradingOffice(city);
		if (availableAmountShip>0 && optOffice.isPresent()){
			Map<IWare, Integer> amounts = new HashMap<>();
			amounts.put(ware, transfer.getAmount(availableAmountShip));
			tradeService.transferFromVesselToStorage(ship, player, city, amounts);
		}
	}


}
