package ch.sahits.game.openpatrician.display.javafx.action;


import ch.sahits.game.openpatrician.clientserverinterface.service.TradeService;
import ch.sahits.game.openpatrician.display.dialog.service.ITransferableJFX;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Map;
import java.util.Map.Entry;
import java.util.Optional;

/**
 * This action handles the transfer of wares from the storage to the ship.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 24, 2011
 *
 */
@Prototype
@ClassCategory({EClassCategory.HANDLER, EClassCategory.PROTOTYPE_BEAN})
public class Storage2ShipJFXAction implements Runnable {
	private final IWare ware;
	private final ITransferableJFX transfer;

	@Autowired
	private TradeService tradeService;

	public Storage2ShipJFXAction(IWare ware, ITransferableJFX transfer) {
		super();
		this.ware = ware;
		this.transfer=transfer;
	}

	@Override
	public void run() {
		INavigableVessel ship = transfer.getVessel();
        final IPlayer player = transfer.getPlayer();
        Optional<ITradingOffice> optOffice = player.findTradingOffice(transfer.getCity());
		if (optOffice.isPresent() && optOffice.get().getWare(ware).getAmount()>0){
			ITradingOffice office = optOffice.get();
            final AmountablePrice<IWare> amountable = office.getWare(this.ware);
            int availableAmountStorage = amountable.getAmount();
            int amount2Move = transfer.getAmount(availableAmountStorage); // This is ware specific size
            tradeService.transferFromStorageToVessel(office, ship, player, ware, amount2Move);
		}
	}
	
}
