package ch.sahits.game.openpatrician.display.service;

import ch.sahits.game.graphic.image.IFontLoader;
import ch.sahits.game.openpatrician.display.javafx.MainGameView;
import ch.sahits.game.openpatrician.display.javafx.control.GameStatus;
import ch.sahits.game.openpatrician.display.javafx.control.MainMenu;
import ch.sahits.game.openpatrician.display.javafx.control.MiniMap;
import ch.sahits.game.openpatrician.display.javafx.control.ViewStatus;
import ch.sahits.game.openpatrician.javafx.control.NoticeBoard;
import ch.sahits.game.openpatrician.display.javafx.control.SubMenu;

/**
 * Bean loader for JavaFX controls.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Nov 1, 2013
 *
 */
public interface IJavaFXControlLoader {
	/**
	 * Retrieve the control instance for the mini map.
	 * @return MiniMap
	 */
	MiniMap getMiniMap();
	/**
	 * Retrieve the control instance for the main menu.
	 * @return MainMenu
	 */
	MainMenu getMainMenu();
	/**
	 * Retrieve the control instance for the sub menu.
	 * @return SubMenu
	 */
	SubMenu getSubMenu();
	/**
	 * Retrieve the control for the notice board.
	 * @return NoticeBoard
	 */
	NoticeBoard getNoticeBoard();
	/**
	 * Retrieve the control for the view status pane.
	 * @return ViewStatus
	 */
	ViewStatus getViewStatus();
	/**
	 * Get the font loader.
	 * @return
	 */
	IFontLoader getFontLoader();
	/**
	 * Retrieve the control for the game status pane.
	 * @return GameStatus
	 */
	GameStatus getGameStatus();
	/**
	 * Retrieve the control for the main view.
	 * @param width
	 * @param heigth
	 * @return
	 */
	MainGameView getMainGameView(double width, double heigth);
}
