/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog;

import ch.sahits.game.graphic.image.impl.SelectiveCachableXMLImageLoader;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.dialog.TabelViewDialog;
import ch.sahits.game.openpatrician.event.NoticeBoardClose;
import ch.sahits.game.openpatrician.javafx.control.BaleIconView;
import ch.sahits.game.openpatrician.javafx.control.BarrelIconView;
import ch.sahits.game.openpatrician.javafx.control.CoinIconView;
import ch.sahits.game.openpatrician.javafx.model.ControlTableCell;
import ch.sahits.game.openpatrician.javafx.model.ITableCell;
import ch.sahits.game.openpatrician.javafx.model.StaticTextTableCell;
import ch.sahits.game.openpatrician.javafx.model.Table;
import ch.sahits.game.openpatrician.javafx.model.TableHeader;
import ch.sahits.game.openpatrician.javafx.model.TableRow;
import ch.sahits.game.openpatrician.model.building.ELevel;
import ch.sahits.game.openpatrician.model.building.IStorage;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class StorageOverviewDialog
extends TabelViewDialog {
    protected final ICityPlayerProxyJFX city;
    @Autowired
    @Qualifier(value="xmlImageLoader")
    private SelectiveCachableXMLImageLoader imageLoader;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;

    public StorageOverviewDialog(ICityPlayerProxyJFX city) {
        this.city = city;
    }

    @Override
    public void executeOnCloseButtonClicked() {
        this.clientEventBus.post((Object)new NoticeBoardClose());
        super.executeOnCloseButtonClicked();
    }

    @PostConstruct
    private void initializeModelAndDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.CityStorageTradeDialog.storage", new Object[0], this.locale.getCurrentLocal()));
        Table model = this.createModel();
        this.setModel(model);
    }

    private Table createModel() {
        Optional optOffice = this.city.getPlayer().findTradingOffice(this.city.getCity());
        Preconditions.checkArgument((boolean)optOffice.isPresent(), (Object)"The trading office must be present.");
        final ITradingOffice office = (ITradingOffice)optOffice.get();
        IStorage storage = office.getStorage();
        Table model = new Table();
        TableHeader header = new TableHeader(4);
        header.add((ITableCell)new StaticTextTableCell(""));
        header.add((ITableCell)new StaticTextTableCell(""));
        header.add((ITableCell)new StaticTextTableCell(""));
        header.add((ITableCell)new StaticTextTableCell(""));
        model.setHeader(header);
        model.setAligenment(0, HPos.LEFT);
        model.setAligenment(1, HPos.RIGHT);
        model.setAligenment(2, HPos.RIGHT);
        model.setAligenment(3, HPos.LEFT);
        model.setColumnWidth(new Integer[]{210, 120, 30, 30});
        TableRow row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.StorageOverviewDialog.requiredCapacity", new Object[0], this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        Text amount = new Text();
        amount.getStyleClass().add((Object)"dialogText");
        amount.textProperty().bind((ObservableValue)office.storedAmountBinding().divide(10).asString());
        row.add((ITableCell)new ControlTableCell((Node)amount));
        BaleIconView baleAmount = new BaleIconView();
        row.add((ITableCell)new ControlTableCell((Node)baleAmount));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.StorageOverviewDialog.availableCap", new Object[0], this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        Text capacityTxt = new Text();
        capacityTxt.getStyleClass().add((Object)"dialogText");
        capacityTxt.textProperty().bind((ObservableValue)office.capacityProperty().asString());
        row.add((ITableCell)new ControlTableCell((Node)capacityTxt));
        baleAmount = new BaleIconView();
        row.add((ITableCell)new ControlTableCell((Node)baleAmount));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.StorageOverviewDialog.additionalCap", new Object[0], this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        IntegerBinding additionalAmount = new IntegerBinding(){
            {
                super.bind(new Observable[]{office.storedAmountBinding(), office.capacityProperty()});
            }

            protected int computeValue() {
                return Math.max(office.storedAmountBinding().subtract((ObservableNumberValue)office.capacityProperty()).intValue(), 0);
            }
        };
        Text additionalAmountTxt = new Text();
        additionalAmountTxt.getStyleClass().add((Object)"dialogText");
        additionalAmountTxt.textProperty().bind((ObservableValue)additionalAmount.asString());
        row.add((ITableCell)new ControlTableCell((Node)additionalAmountTxt));
        baleAmount = new BaleIconView();
        row.add((ITableCell)new ControlTableCell((Node)baleAmount));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.StorageOverviewDialog.otherGoods", new Object[0], this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        Text otherTxt = new Text();
        otherTxt.getStyleClass().add((Object)"dialogText");
        otherTxt.textProperty().bind((ObservableValue)storage.rentOutStorageProperty().asString());
        row.add((ITableCell)new ControlTableCell((Node)otherTxt));
        BarrelIconView barrelAmount = new BarrelIconView();
        row.add((ITableCell)new ControlTableCell((Node)barrelAmount));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.StorageOverviewDialog.costs", new Object[0], this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        Text storageCosts = new Text();
        storageCosts.getStyleClass().add((Object)"dialogText");
        storageCosts.textProperty().bind((ObservableValue)storage.costsPerDayBinding().asString());
        row.add((ITableCell)new ControlTableCell((Node)storageCosts));
        CoinIconView coinAmount = new CoinIconView();
        row.add((ITableCell)new ControlTableCell((Node)coinAmount));
        model.add(row);
        this.addEmptyRow(model);
        this.addEmptyRow(model);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.StorageOverviewDialog.guards", new Object[0], this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.StorageOverviewDialog.noGuards", new Object[0], this.locale.getCurrentLocal())));
        Image minus = this.imageLoader.getImage("icons/minusIcon");
        ImageView minusView = new ImageView(minus);
        Label minusLbl = new Label("", (Node)minusView);
        minusLbl.setOnMouseReleased(arg0 -> storage.updateGuardsNumber(-1));
        row.add((ITableCell)new ControlTableCell((Node)minusLbl));
        Text nbGuardsTxt = new Text();
        nbGuardsTxt.getStyleClass().add((Object)"dialogText");
        nbGuardsTxt.textProperty().bind((ObservableValue)storage.numberGuardsProperty().asString());
        row.add((ITableCell)new ControlTableCell((Node)nbGuardsTxt));
        Image plus = this.imageLoader.getImage("icons/plusIcon");
        ImageView plusView = new ImageView(plus);
        Label plusLbl = new Label("", (Node)plusView);
        plusLbl.setOnMouseReleased(arg0 -> storage.updateGuardsNumber(1));
        row.add((ITableCell)new ControlTableCell((Node)plusLbl));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.StorageOverviewDialog.costs", new Object[0], this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        Text guardsCosts = new Text();
        guardsCosts.getStyleClass().add((Object)"dialogText");
        guardsCosts.textProperty().bind((ObservableValue)storage.guardCostsPerDayBinding().asString());
        row.add((ITableCell)new ControlTableCell((Node)guardsCosts));
        coinAmount = new CoinIconView();
        row.add((ITableCell)new ControlTableCell((Node)coinAmount));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.StorageOverviewDialog.security", new Object[0], this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        Text securityTxt = new Text();
        securityTxt.getStyleClass().add((Object)"dialogText");
        securityTxt.textProperty().bind((ObservableValue)new LevelBinding((ObjectBinding<ELevel>)storage.securityLevelBinding()));
        row.add((ITableCell)new ControlTableCell((Node)securityTxt));
        row.add((ITableCell)new StaticTextTableCell(""));
        model.add(row);
        return model;
    }

    private void addEmptyRow(Table model) {
        TableRow row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        model.add(row);
    }

    private static class LevelBinding
    extends StringBinding {
        private final ObjectBinding<ELevel> levelBinding;

        LevelBinding(ObjectBinding<ELevel> levelBinding) {
            this.levelBinding = levelBinding;
            super.bind(new Observable[]{levelBinding});
        }

        protected String computeValue() {
            return ((ELevel)this.levelBinding.get()).name();
        }
    }
}

