/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.events;

import ch.sahits.game.openpatrician.clientserverinterface.model.event.BuildingPermissionState;
import ch.sahits.game.openpatrician.display.dialog.DefaultSimpleDialog;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import javafx.geometry.Pos;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN})
public class BuildingPermissionDialog
extends DefaultSimpleDialog {
    @Autowired
    private ModelTranslations modelTranslations;
    private BuildingPermissionState state;

    public BuildingPermissionDialog(BuildingPermissionState state) {
        super(true);
        this.state = state;
    }

    @PostConstruct
    private void initializeDialog() {
        String letterDate = this.modelTranslations.toDisplayString(this.state.getDate());
        this.addDecoratedText("letter.location.date", "dateLocation", Pos.CENTER_RIGHT, new Object[]{this.state.getLocation(), letterDate});
        this.addVerticalSpacer(20);
        this.addDecoratedText("ch.sahits.game.openpatrician.display.dialog.event.BuildingPermissionDialog.title", "title", Pos.CENTER, new Object[0]);
        this.addVerticalSpacer(20);
        IPlayer player = this.state.getPlayer();
        String careerLevel = this.modelTranslations.getLocalDisplayName(player.getCareerLevel());
        String rank = this.modelTranslations.getLocalDisplayName(player.getRank());
        this.addDecoratedText("letter.salutation.with.title", "salutation", careerLevel, rank, player.getName(), player.getLastName());
        this.addVerticalSpacer(20);
        this.addDecoratedText("ch.sahits.game.openpatrician.display.dialog.event.BuildingPermissionDialog.permission", "permission", this.state.getLocation());
        this.addDecoratedText("ch.sahits.game.openpatrician.display.dialog.event.BuildingPermissionDialog.greetings", "greetings", new Object[0]);
        this.addVerticalSpacer(20);
        this.addDecoratedText("ch.sahits.game.openpatrician.display.dialog.event.BuildingPermissionDialog.signature", "signature", Pos.CENTER_RIGHT, new Object[]{this.state.getLocation()});
    }
}

