/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.events;

import ch.sahits.game.openpatrician.clientserverinterface.model.event.SocialAdvancementState;
import ch.sahits.game.openpatrician.display.dialog.DefaultSimpleDialog;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import javafx.geometry.Pos;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN})
public class SocialAdvancementDialog
extends DefaultSimpleDialog {
    @Autowired
    private ModelTranslations modelTranslations;
    private SocialAdvancementState state;

    public SocialAdvancementDialog(SocialAdvancementState state) {
        super(true);
        this.state = state;
    }

    @PostConstruct
    private void initializeDialog() {
        String letterDate = this.modelTranslations.toDisplayString(this.state.getDate());
        this.addDecoratedText("letter.location.date", "dateLocation", Pos.CENTER_RIGHT, new Object[]{this.state.getLocation(), letterDate});
        this.addVerticalSpacer(20);
        String newRank = this.modelTranslations.getLocalDisplayName(this.state.getRank());
        if (this.state.getRank() == ESocialRank.ALDERMAN) {
            this.addDecoratedText("ch.sahits.game.openpatrician.display.dialog.event.SocialAdvancementDeficitDialog.advanceAlderman", "advanceAlderman", letterDate);
        } else if (this.state.getRank() == ESocialRank.MAYOR) {
            this.addDecoratedText("ch.sahits.game.openpatrician.display.dialog.event.SocialAdvancementDeficitDialog.advanceMayor", "advanceMayor", this.state.getLocation(), letterDate);
        } else {
            this.addDecoratedText("ch.sahits.game.openpatrician.display.dialog.event.SocialAdvancementDeficitDialog.advance", "advance", this.state.getLocation(), newRank);
        }
    }
}

