/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.guild;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.GuildService;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.IViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.guild.GuildList;
import ch.sahits.game.openpatrician.model.city.guild.IGuild;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import java.util.HashMap;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class JoinGuildDialog
extends CloseButtonDialog {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final ICityPlayerProxyJFX city;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private GuildList guildList;
    @Autowired
    private GuildService guildService;

    public JoinGuildDialog(ICityPlayerProxyJFX city) {
        this.city = city;
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.guild.JoinGuildDialog.title", new Object[0], this.locale.getCurrentLocal()));
        IHumanPlayer player = this.city.getPlayer();
        ICity city = this.city.getCity();
        int fee = this.guildService.getEntryFee((IPlayer)player);
        String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.guild.JoinGuildDialog.text", new Object[]{city.getName(), player.getName(), player.getLastName(), fee}, this.locale.getCurrentLocal());
        DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
        VBox box = new VBox(new Node[]{text});
        String s = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.guild.JoinGuildDialog.joinBtn", new Object[0], this.locale.getCurrentLocal());
        OpenPatricianLargeWaxButton action = new OpenPatricianLargeWaxButton(s);
        action.getStyleClass().add((Object)"actionButton");
        action.setId("joinGuild");
        int actionButtonX = 197;
        action.setLayoutX(197.0);
        action.setLayoutY(603.0);
        action.setOnAction(this.joinGuild(player, city, fee));
        box.setLayoutX(50.0);
        box.setLayoutY(127.0);
        this.getContent().addAll((Object[])new Node[]{box, action});
    }

    private EventHandler<MouseEvent> joinGuild(IHumanPlayer player, ICity city, int fee) {
        return mouseEvent -> {
            try {
                ICompany company = player.getCompany();
                company.updateCash((long)(-fee));
                IGuild guild = (IGuild)this.guildList.findGuild(city).get();
                guild.join((IPlayer)player);
                ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.city, (IViewChangeEvent)EViewChangeEvent.MAIN_VIEW_GUILD);
                this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
                this.executeOnCloseButtonClicked();
            }
            catch (RuntimeException e) {
                this.logger.error("Failed to join the quild", (Throwable)e);
            }
        };
    }
}

