/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.sea;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.display.dialog.IDialogCentralButton;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.IViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.model.ship.ConvoyList;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import java.util.HashMap;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class LeaveConvoyDialog
extends CloseButtonDialog
implements IDialogCentralButton {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final ICityPlayerProxyJFX city;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private ConvoyList convoyList;
    private final IConvoy convoy;
    private final IShip ship;

    public LeaveConvoyDialog(ICityPlayerProxyJFX city, IConvoy convoy, IShip ship) {
        this.city = city;
        this.convoy = convoy;
        this.ship = ship;
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.sea.LeaveConvoyDialog.title", new Object[0], this.locale.getCurrentLocal()));
        String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.sea.LeaveConvoyDialog.text", new Object[]{this.ship.getName(), this.convoy.getName()}, this.locale.getCurrentLocal());
        DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
        VBox box = new VBox(new Node[]{text});
        box.setLayoutX(50.0);
        box.setLayoutY(127.0);
        OpenPatricianLargeWaxButton acceptBtn = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.sea.LeaveConvoyDialog.leave", new Object[0], this.locale.getCurrentLocal()));
        acceptBtn.getStyleClass().add((Object)"actionButton");
        acceptBtn.setId("actionButton");
        acceptBtn.setLayoutX(197.0);
        acceptBtn.setOnAction(this.createAcceptHandler(this.ship));
        acceptBtn.setLayoutY(579.0);
        this.getContent().addAll((Object[])new Node[]{box, acceptBtn});
    }

    private EventHandler<MouseEvent> createAcceptHandler(IShip ship) {
        return event -> {
            try {
                this.convoy.removeShip(ship);
                ship.parentShipProperty().setValue(null);
                ICityPlayerProxyJFX proxy = this.viewState.getCurrentCityProxy().get();
                proxy.arrive((INavigableVessel)ship);
                proxy.getPlayer().addSelectableVessel((INavigableVessel)ship);
                this.executeOnCloseButtonClicked();
            }
            catch (RuntimeException e) {
                this.logger.error("Failed to leave convoy", (Throwable)e);
            }
        };
    }

    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_SHIP_SELECTION);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }
}

