/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.service.impl;

import ch.sahits.game.openpatrician.display.dialog.service.ITransferableJFX;
import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ComputablePriceV2;
import ch.sahits.game.openpatrician.model.product.ETransferAmount;
import ch.sahits.game.openpatrician.model.service.TransferUtil;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.beans.ConstructorProperties;

@ClassCategory(value={EClassCategory.MODEL, EClassCategory.DIALOG})
public class TransferableState
implements ITransferableJFX {
    private final INavigableVessel vessel;
    private final ICity city;
    private final IPlayer player;
    private final EDialogType dialogType;
    private final ETransferAmount movableAmount;
    private static final TransferUtil transferUtility = new TransferUtil();
    private static final ComputablePriceV2 computablePrice = new ComputablePriceV2();

    @Override
    public int getAmount(int availableAmountCity) {
        return transferUtility.calculateAvailableAmount(this.movableAmount, availableAmountCity);
    }

    @Override
    public ComputablePriceV2 getComputablePrice() {
        return computablePrice;
    }

    @ConstructorProperties(value={"vessel", "city", "player", "dialogType", "movableAmount"})
    TransferableState(INavigableVessel vessel, ICity city, IPlayer player, EDialogType dialogType, ETransferAmount movableAmount) {
        this.vessel = vessel;
        this.city = city;
        this.player = player;
        this.dialogType = dialogType;
        this.movableAmount = movableAmount;
    }

    public static TransferableStateBuilder builder() {
        return new TransferableStateBuilder();
    }

    @Override
    public INavigableVessel getVessel() {
        return this.vessel;
    }

    @Override
    public ICity getCity() {
        return this.city;
    }

    @Override
    public IPlayer getPlayer() {
        return this.player;
    }

    @Override
    public EDialogType getDialogType() {
        return this.dialogType;
    }

    @Override
    public ETransferAmount getMovableAmount() {
        return this.movableAmount;
    }

    public static class TransferableStateBuilder {
        private INavigableVessel vessel;
        private ICity city;
        private IPlayer player;
        private EDialogType dialogType;
        private ETransferAmount movableAmount;

        TransferableStateBuilder() {
        }

        public TransferableStateBuilder vessel(INavigableVessel vessel) {
            this.vessel = vessel;
            return this;
        }

        public TransferableStateBuilder city(ICity city) {
            this.city = city;
            return this;
        }

        public TransferableStateBuilder player(IPlayer player) {
            this.player = player;
            return this;
        }

        public TransferableStateBuilder dialogType(EDialogType dialogType) {
            this.dialogType = dialogType;
            return this;
        }

        public TransferableStateBuilder movableAmount(ETransferAmount movableAmount) {
            this.movableAmount = movableAmount;
            return this;
        }

        public TransferableState build() {
            return new TransferableState(this.vessel, this.city, this.player, this.dialogType, this.movableAmount);
        }

        public String toString() {
            return "TransferableState.TransferableStateBuilder(vessel=" + this.vessel + ", city=" + this.city + ", player=" + this.player + ", dialogType=" + this.dialogType + ", movableAmount=" + this.movableAmount + ")";
        }
    }
}

