/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.shipyard;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.model.WeaponSlotCount;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.ShipFactory;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.display.dialog.shipyard.BaseShipyardDialog;
import ch.sahits.game.openpatrician.display.model.RequiredWareCityStorage;
import ch.sahits.game.openpatrician.event.data.ShipyardOrderBuild;
import ch.sahits.game.openpatrician.javafx.control.BaleAmountAlwaysVisible;
import ch.sahits.game.openpatrician.javafx.control.BarrelAmount;
import ch.sahits.game.openpatrician.javafx.control.BarrelAmountAlwaysVisible;
import ch.sahits.game.openpatrician.javafx.control.CoinPriceAlwaysVisible;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.model.ControlTableCell;
import ch.sahits.game.openpatrician.javafx.model.ECellConstraint;
import ch.sahits.game.openpatrician.javafx.model.ITableCell;
import ch.sahits.game.openpatrician.javafx.model.StaticTextTableCell;
import ch.sahits.game.openpatrician.javafx.model.Table;
import ch.sahits.game.openpatrician.javafx.model.TableHeader;
import ch.sahits.game.openpatrician.javafx.model.TableRow;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.impl.ShipWeaponsLocationFactory;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="shipyardConstructionDialog")
@Scope(value="prototype")
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.SINGLETON_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class ShipyardConstructionDialogV2
extends BaseShipyardDialog {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    private ShipFactory shipFactory;
    @Autowired
    private ShipWeaponsLocationFactory weaponsLocationFactory;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private ShipService shipService;
    private static final EWare[] MATERIALS = new EWare[]{EWare.WOOD, EWare.CLOTH, EWare.IRON, EWare.HEMP, EWare.PITCH};
    @MapType(key=IWare.class, value=RequiredWareCityStorage.class)
    private HashMap<IWare, RequiredWareCityStorage> requirementsMap = new HashMap();

    public ShipyardConstructionDialogV2(ICityPlayerProxyJFX city) {
        super(city);
    }

    @PostConstruct
    private void init() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.ShipyardConstructionDialogV2.title", new Object[0], this.locale.getCurrentLocal()));
    }

    @Override
    protected void initializeRequirements() {
        ICity city = this.getCity();
        Optional optOffice = this.getPlayer().findTradingOffice(city);
        for (EWare material : MATERIALS) {
            SimpleIntegerProperty amountInStorage;
            int requiredAmount = this.shipFactory.getConstructionAmount(this.getCurrentShipType(), material);
            ReadOnlyIntegerProperty amountInCity = city.getWare((IWare)material).amountProperty();
            if (optOffice.isPresent()) {
                ITradingOffice office = (ITradingOffice)optOffice.get();
                amountInStorage = office.getWare((IWare)material).amountProperty();
            } else {
                amountInStorage = new SimpleIntegerProperty(0);
            }
            if (this.requirementsMap.containsKey(material)) {
                RequiredWareCityStorage requiredWare = this.requirementsMap.get(material);
                requiredWare.setRequired(requiredAmount);
                requiredWare.inStorageProperty().unbind();
                requiredWare.inStorageProperty().bind((ObservableValue)amountInStorage);
                requiredWare.inCityProperty().unbind();
                requiredWare.inCityProperty().bind((ObservableValue)amountInCity);
                continue;
            }
            SimpleIntegerProperty inCity = new SimpleIntegerProperty();
            inCity.bind((ObservableValue)amountInCity);
            SimpleIntegerProperty inStorage = new SimpleIntegerProperty();
            inStorage.bind((ObservableValue)amountInStorage);
            RequiredWareCityStorage requiredWare = new RequiredWareCityStorage(requiredAmount, (IntegerProperty)inStorage, (IntegerProperty)inCity, (IWare)material, this.computablePrice);
            this.requirementsMap.put((IWare)material, requiredWare);
        }
    }

    @Override
    protected EventHandler<MouseEvent> getAction() {
        return mouseEvent -> {
            try {
                ICity city = this.getCity();
                Optional office = this.getPlayer().findTradingOffice(this.getCity());
                Preconditions.checkArgument((boolean)office.isPresent(), (Object)"Trading office must be present");
                for (EWare ware : MATERIALS) {
                    int buyAmount = this.requirementsMap.get(ware).getBuyAmount().intValue();
                    city.move((IWare)ware, -buyAmount, (ICitizen)this.getPlayer());
                    int needed = this.requirementsMap.get(ware).requiredProperty().get();
                    int fromWarhouse = needed - buyAmount;
                    ((ITradingOffice)office.get()).move((IWare)ware, -fromWarhouse);
                }
                ShipyardOrderBuild event = new ShipyardOrderBuild(city.getCityState().getShipyardState(), this.getCurrentShipType(), (IPlayer)this.getPlayer());
                this.clientServerEventBus.post((Object)event);
                this.getPlayer().getCompany().updateCash((long)(-this.calculateTotalBuildCosts()));
                this.executeOnCloseButtonClicked();
            }
            catch (RuntimeException e) {
                this.logger.error("Failed to order ship construction", (Throwable)e);
            }
        };
    }

    @Override
    protected String getActionText() {
        return this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.ShipyardConstructionDialogV2.build", new Object[0], this.locale.getCurrentLocal());
    }

    @Override
    protected Group createFooterText() {
        IntegerBinding totalPriceBinding = new IntegerBinding(){
            {
                for (EWare ware : MATERIALS) {
                    RequiredWareCityStorage requiredWare = (RequiredWareCityStorage)ShipyardConstructionDialogV2.this.requirementsMap.get(ware);
                    super.bind(new Observable[]{requiredWare.buyPriceProperty()});
                }
            }

            protected int computeValue() {
                return ShipyardConstructionDialogV2.this.calculateTotalBuildCosts();
            }
        };
        Group g = new Group();
        String t = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.ShipyardConstructionDialogV2.totalSum", new Object[0], this.locale.getCurrentLocal());
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("price", totalPriceBinding.get());
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(t, parameters);
        dt.setId("totalSum");
        g.getChildren().add((Object)dt);
        g.setId("footerText");
        return g;
    }

    private int calculateTotalBuildCosts() {
        int total = this.getCity().getCityState().getShipyardState().calculateConstructionCosts(this.getCurrentShipType());
        for (EWare ware : MATERIALS) {
            RequiredWareCityStorage requiredWare = this.requirementsMap.get(ware);
            total += requiredWare.getBuyPrice().intValue();
        }
        return total;
    }

    @Override
    protected Table createMainTable() {
        Table model = new Table();
        TableHeader header = new TableHeader(5);
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.ShipyardConstructionDialogV2.materials", new Object[0], this.locale.getCurrentLocal())), ECellConstraint.COLSPAN2);
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.ShipyardConstructionDialogV2.stored", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.ShipyardConstructionDialogV2.buy", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.ShipyardConstructionDialogV2.costs", new Object[0], this.locale.getCurrentLocal())));
        header.setAligenment(0, HPos.CENTER);
        header.setAligenment(2, HPos.CENTER);
        header.setAligenment(3, HPos.CENTER);
        header.setAligenment(4, HPos.CENTER);
        model.setHeader(header);
        model.setAligenment(0, HPos.RIGHT);
        model.setAligenment(1, HPos.RIGHT);
        model.setAligenment(2, HPos.RIGHT);
        model.setAligenment(3, HPos.RIGHT);
        model.setAligenment(4, HPos.RIGHT);
        model.setColumnWidth(new Integer[]{70, 70, 70, 70, 100});
        for (EWare ware : MATERIALS) {
            RequiredWareCityStorage requiredWare = this.requirementsMap.get(ware);
            TableRow row = new TableRow();
            row.add((ITableCell)new StaticTextTableCell(this.translator.getLocalDisplayName(ware)));
            IntegerProperty needed = requiredWare.requiredProperty();
            if (ware.isBarrelSizedWare()) {
                BarrelAmountAlwaysVisible barrelAmount = new BarrelAmountAlwaysVisible();
                barrelAmount.amountProperty().bind((ObservableValue)needed.asString());
                row.add((ITableCell)new ControlTableCell((Node)barrelAmount));
            } else {
                BaleAmountAlwaysVisible baleAmount = new BaleAmountAlwaysVisible();
                baleAmount.amountProperty().bind((ObservableValue)needed.asString());
                row.add((ITableCell)new ControlTableCell((Node)baleAmount));
            }
            IntegerProperty stored = requiredWare.inStorageProperty();
            if (ware.isBarrelSizedWare()) {
                BarrelAmountAlwaysVisible barrelAmount = new BarrelAmountAlwaysVisible();
                barrelAmount.amountProperty().bind((ObservableValue)stored.asString());
                row.add((ITableCell)new ControlTableCell((Node)barrelAmount));
            } else {
                BaleAmountAlwaysVisible baleAmount = new BaleAmountAlwaysVisible();
                baleAmount.amountProperty().bind((ObservableValue)stored.asString());
                row.add((ITableCell)new ControlTableCell((Node)baleAmount));
            }
            IntegerBinding buyAmount = requiredWare.buyAmountProperty();
            if (ware.isBarrelSizedWare()) {
                BarrelAmountAlwaysVisible barrelAmount = new BarrelAmountAlwaysVisible();
                barrelAmount.amountProperty().bind((ObservableValue)buyAmount.asString());
                row.add((ITableCell)new ControlTableCell((Node)barrelAmount));
            } else {
                BaleAmountAlwaysVisible baleAmount = new BaleAmountAlwaysVisible();
                baleAmount.amountProperty().bind((ObservableValue)buyAmount.asString());
                row.add((ITableCell)new ControlTableCell((Node)baleAmount));
            }
            IntegerBinding priceBinding = requiredWare.buyPriceProperty();
            CoinPriceAlwaysVisible price = new CoinPriceAlwaysVisible();
            price.amountProperty().bind((ObservableValue)priceBinding.asString());
            row.add((ITableCell)new ControlTableCell((Node)price));
            model.add(row);
        }
        return model;
    }

    @Override
    protected Table createTopTable() {
        int capacity = this.shipFactory.calculateInitialCapacity(this.getCurrentShipType(), this.getCity().getCoordinates().getX());
        List shipWeapons = this.weaponsLocationFactory.getShipWeaponsLocation(this.getCurrentShipType(), EShipUpgrade.NONE);
        Table model = new Table();
        TableHeader header = new TableHeader(5);
        model.setHeader(header);
        model.setColumnWidth(new Integer[]{70, 70, 70, 70, 70});
        TableRow row = new TableRow();
        BarrelAmount capacityAmount = new BarrelAmount();
        capacityAmount.setAmount(Integer.valueOf(capacity));
        row.add((ITableCell)new ControlTableCell((Node)capacityAmount));
        WeaponSlotCount slotCount = this.shipService.getWeaponSlotCount(shipWeapons);
        row.add((ITableCell)new StaticTextTableCell(String.valueOf(slotCount.getNbSmallSlots())));
        row.add((ITableCell)new StaticTextTableCell(String.valueOf(slotCount.getNbLargeSlots())));
        row.add((ITableCell)new StaticTextTableCell(String.valueOf(this.shipFactory.getShipSpeed(this.getCurrentShipType()))));
        row.add((ITableCell)new StaticTextTableCell(String.valueOf(this.shipFactory.getMinimalSailors(this.getCurrentShipType()))));
        model.add(row);
        return model;
    }

    @Override
    protected BooleanProperty disableNavigation() {
        return new SimpleBooleanProperty(false);
    }

    @Override
    protected BooleanBinding actionEnabledBinding() {
        return new BooleanBinding(){
            {
                for (EWare ware : MATERIALS) {
                    RequiredWareCityStorage requiredWare = (RequiredWareCityStorage)ShipyardConstructionDialogV2.this.requirementsMap.get(ware);
                    super.bind(new Observable[]{requiredWare.canBuyProperty()});
                }
                super.bind(new Observable[]{ShipyardConstructionDialogV2.this.getPlayer().getCompany().cashProperty()});
            }

            protected boolean computeValue() {
                long buildCosts;
                long cash = ShipyardConstructionDialogV2.this.getPlayer().getCompany().getCash();
                if (cash < (buildCosts = (long)ShipyardConstructionDialogV2.this.calculateTotalBuildCosts())) {
                    return false;
                }
                for (EWare ware : MATERIALS) {
                    RequiredWareCityStorage requiredWare = (RequiredWareCityStorage)ShipyardConstructionDialogV2.this.requirementsMap.get(ware);
                    if (requiredWare.canBuyProperty().get()) continue;
                    return false;
                }
                return true;
            }
        };
    }

    @Override
    protected void selectionChanged() {
        super.selectionChanged();
        this.initializeRequirements();
        Group footerText = this.createFooterText();
        footerText.setLayoutX(50.0);
        footerText.setLayoutY(454.0);
        Iterator iterator = this.getContent().iterator();
        while (iterator.hasNext()) {
            Node child = (Node)iterator.next();
            if (!"footerText".equals(child.getId())) continue;
            iterator.remove();
            break;
        }
        this.getContent().add((Object)footerText);
    }
}

