/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.tavern;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.display.dialog.service.TavernDialogUtil;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.IViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.people.ITrader;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import java.util.HashMap;
import java.util.Optional;
import javafx.beans.binding.BooleanBinding;
import javafx.scene.Node;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernTraderDialog
extends CloseButtonDialog {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    private final ICityPlayerProxyJFX city;
    private final ITrader trader;
    @Autowired
    private TavernDialogUtil tavernDialogUtil;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private Locale locale;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    private MessageSource messageSource;
    private final TavernState tavernState;

    public TavernTraderDialog(ICityPlayerProxyJFX city) {
        this.city = city;
        this.tavernState = city.getCity().getCityState().getTavernState();
        this.trader = this.tavernState.getTrader();
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernTraderDialog.title", new Object[0], this.locale.getCurrentLocal()));
        IWare ware = this.trader.getWare();
        String loadedText = ware.isBarrelSizedWare() ? this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernTraderDialog.dialogBarrel", new Object[]{this.city.getPlayer().getLastName(), this.translator.getLocalDisplayName((EWare)ware)}, this.locale.getCurrentLocal()) : this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernTraderDialog.dialogBale", new Object[]{this.city.getPlayer().getLastName(), this.translator.getLocalDisplayName((EWare)ware)}, this.locale.getCurrentLocal());
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("amount", this.trader.getAmount());
        parameters.put("price", this.trader.getAvgPricePerItem());
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        OpenPatricianLargeWaxButton acceptButton = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernBaseSideRoomPersonDialog.accept", new Object[0], this.locale.getCurrentLocal()));
        acceptButton.getStyleClass().add((Object)"actionButton");
        int BUTTON_X = 197;
        acceptButton.setLayoutX((double)BUTTON_X);
        int LOWER_BUTTON_Y = 603;
        acceptButton.setLayoutY((double)LOWER_BUTTON_Y);
        acceptButton.setOnAction(mouseEvent -> {
            try {
                IHumanPlayer player = this.city.getPlayer();
                int price = this.trader.getAmount() * this.trader.getAvgPricePerItem();
                Optional optOffice = this.city.getPlayer().findTradingOffice(this.city.getCity());
                if (optOffice.isPresent()) {
                    ((ITradingOffice)optOffice.get()).move(this.trader.getWare(), this.trader.getAmount());
                } else {
                    IShip ship = null;
                    if (this.city.getActiveShip() instanceof IShip) {
                        ship = (IShip)this.city.getActiveShip();
                    }
                    if (ship == null) {
                        acceptButton.setDisable(true);
                        return;
                    }
                    if (ship.getCapacity() < this.trader.getAmount()) {
                        acceptButton.setDisable(true);
                        return;
                    }
                    ship.load(this.trader.getWare(), this.trader.getAmount(), this.trader.getAvgPricePerItem());
                }
                player.getCompany().updateCash((long)(-price));
                this.trader.leave();
                this.executeOnCloseButtonClicked();
                return;
            }
            catch (RuntimeException e) {
                this.logger.error("Failed to accept traders offer", (Throwable)e);
            }
        });
        BooleanBinding disable = this.disableAcceptBinding();
        acceptButton.setDisable(disable.get());
        disable.addListener((observableValue, oldValue, newValue) -> acceptButton.setDisable(newValue.booleanValue()));
        this.getContent().addAll((Object[])new Node[]{dt, acceptButton});
    }

    private BooleanBinding disableAcceptBinding() {
        return new BooleanBinding(){

            protected boolean computeValue() {
                Optional optOffice = TavernTraderDialog.this.city.getPlayer().findTradingOffice(TavernTraderDialog.this.city.getCity());
                IShip ship = null;
                if (TavernTraderDialog.this.city.getActiveShip() instanceof IShip) {
                    ship = (IShip)TavernTraderDialog.this.city.getActiveShip();
                }
                int barrelAmountFactor = 1;
                if (!TavernTraderDialog.this.trader.getWare().isBarrelSizedWare()) {
                    barrelAmountFactor = 10;
                }
                return optOffice.isPresent() && ship == null && ship.getCapacity() < TavernTraderDialog.this.trader.getAmount() * barrelAmountFactor;
            }
        };
    }

    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_TAVERN);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }

    public void close() {
        super.close();
        this.tavernDialogUtil.stopTalkingToPerson(this.tavernState, (IPlayer)this.city.getPlayer());
    }
}

