/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.tavern;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.dialog.tavern.TavernBaseSideRoomPersonDialog;
import ch.sahits.game.openpatrician.display.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.openpatrician.display.event.task.ClientTaskFactory;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.people.ITransportTrader;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernTransportTraderDialog
extends TavernBaseSideRoomPersonDialog {
    @Autowired
    private Random rnd;
    @Autowired
    private ClientTaskFactory taskFactory;
    @Autowired
    private EventHandlerFactory eventHandlerFactory;

    public TavernTransportTraderDialog(ICityPlayerProxyJFX city) {
        super(city, (ISideRoomPerson)city.getCity().getCityState().getTavernState().getTransportTrader());
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernTransportTraderDialog.title", new Object[0], this.locale.getCurrentLocal()));
        this.initializeButtons();
        ITransportTrader trader = (ITransportTrader)this.currentPerson.get();
        String loadedText = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernTransportTraderDialog.dialog", new Object[]{this.city.getCity().getName(), trader.getDestination().getName()}, this.locale.getCurrentLocal());
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("amount", trader.getNeededCapacity());
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        this.getContent().addAll((Object[])new Node[]{dt});
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return mouseEvent -> {
            try {
                ArrayList ships = Lists.newArrayList((Iterable)this.city.getPlayersShips());
                Collections.shuffle(ships);
                ITransportTrader trader = (ITransportTrader)this.currentPerson.get();
                for (IShip ship : ships) {
                    int neededCapacity = trader.getNeededCapacity();
                    if (ship.getCapacity() <= neededCapacity * 10) continue;
                    ship.setOccupiedSpace(neededCapacity);
                    int minutes = this.rnd.nextInt(600);
                    LocalDateTime postMessage = this.date.getCurrentDate().plusMinutes(minutes);
                    this.taskFactory.getPostponedDisplayMessage(postMessage, "ch.sahits.game.openpatrician.display.dialog.TavernTransportTraderDialog.acceptMessage", trader.getDestination().getName(), ship.getName());
                    trader.leave();
                    this.eventHandlerFactory.getUnloadOnArrivalHandler(ship, trader.getDestination(), neededCapacity);
                    break;
                }
                this.executeOnCloseButtonClicked();
            }
            catch (RuntimeException e) {
                this.logger.error("Failed to accept transportation offer", (Throwable)e);
            }
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding(){

            protected boolean computeValue() {
                ITransportTrader trader = (ITransportTrader)TavernTransportTraderDialog.this.currentPerson.get();
                return TavernTransportTraderDialog.this.tavernDialogUtil.noShipWithEnoughCapacityAvailable(TavernTransportTraderDialog.this.city, trader.getNeededCapacity());
            }
        };
    }
}

