/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.tavern;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.display.dialog.service.DialogUtil;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.IViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianSmallWaxButton;
import ch.sahits.game.openpatrician.javafx.model.ControlTableCell;
import ch.sahits.game.openpatrician.javafx.model.ITableCell;
import ch.sahits.game.openpatrician.javafx.model.StaticTextTableCell;
import ch.sahits.game.openpatrician.javafx.model.Table;
import ch.sahits.game.openpatrician.javafx.model.TableHeader;
import ch.sahits.game.openpatrician.javafx.model.TableRow;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.building.IWeaponStorage;
import ch.sahits.game.openpatrician.model.javafx.bindings.StaticIntegerBinding;
import ch.sahits.game.openpatrician.model.people.IWeaponsDealer;
import ch.sahits.game.openpatrician.model.product.ComputablePriceV2;
import ch.sahits.game.openpatrician.model.product.ETransferAmount;
import ch.sahits.game.openpatrician.model.product.ITradable;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.model.service.TransferUtil;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import java.util.HashMap;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernWeaponsDealerDialog
extends CloseButtonDialog {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @ObjectPropertyType(value=ETransferAmount.class)
    private ObjectProperty<ETransferAmount> movableAmount = new SimpleObjectProperty((Object)ETransferAmount.ONE);
    private final ICityPlayerProxyJFX city;
    private IWeaponStorage storage = null;
    private IntegerProperty currentStorageIndex = new SimpleIntegerProperty(-1);
    private StringBinding storageDestinationBinding;
    @Autowired
    private DialogUtil dialogUtil;
    @Autowired
    private TransferUtil transferUtil;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private ComputablePriceV2 computablePrice;
    @Autowired
    private Locale locale;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    private MessageSource messageSource;
    private EWeapon[] weapons = new EWeapon[]{EWeapon.SWORD, EWeapon.BOW, EWeapon.CROSSBOW, EWeapon.MUSKET};
    private final IWeaponsDealer weaponsDealer;

    public TavernWeaponsDealerDialog(ICityPlayerProxyJFX city) {
        this.city = city;
        this.weaponsDealer = city.getCity().getCityState().getTavernState().getWeaponsDealer();
        this.initStorageDestionationBinding();
    }

    @PostConstruct
    private void initializeDialog() {
        Optional office = this.city.getPlayer().findTradingOffice(this.city.getCity());
        if (office.isPresent()) {
            this.storage = ((ITradingOffice)office.get()).getWeaponStorage();
        }
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernWeaponsDealerDialog.title", new Object[0], this.locale.getCurrentLocal()));
        String loadedText = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernWeaponsDealerDialog.dialog1", new Object[0], this.locale.getCurrentLocal());
        HashMap parameters = new HashMap();
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        this.getContent().addAll((Object[])new Node[]{dt});
        GridPane weapnsTable = this.createWeaponsTable();
        this.getContent().add((Object)weapnsTable);
        OpenPatricianSmallWaxButton btn1 = new OpenPatricianSmallWaxButton("1");
        btn1.setId("amountONE");
        btn1.getStyleClass().add((Object)"actionButton");
        btn1.setOnAction(arg0 -> {
            try {
                this.movableAmount.setValue((Object)ETransferAmount.ONE);
            }
            catch (RuntimeException e) {
                this.logger.error("Failed to switch to different movable amount", (Throwable)e);
            }
        });
        OpenPatricianSmallWaxButton btn5 = new OpenPatricianSmallWaxButton("5");
        btn5.setId("amountFIVE");
        btn5.getStyleClass().add((Object)"actionButton");
        btn5.setOnAction(arg0 -> {
            try {
                this.movableAmount.setValue((Object)ETransferAmount.FIVE);
            }
            catch (RuntimeException e) {
                this.logger.error("Failed to switch to different movable amount", (Throwable)e);
            }
        });
        OpenPatricianSmallWaxButton btnMax = new OpenPatricianSmallWaxButton(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.BaseTradeDialog.max", new Object[0], this.locale.getCurrentLocal()));
        btnMax.setId("amountMAX");
        btnMax.getStyleClass().add((Object)"actionButton");
        btnMax.setOnAction(arg0 -> {
            try {
                this.movableAmount.setValue((Object)ETransferAmount.MAX);
            }
            catch (RuntimeException e) {
                this.logger.error("Failed to switch to different movable amount", (Throwable)e);
            }
        });
        this.addButtomControlButtons(btn1, btn5, btnMax);
    }

    private GridPane createWeaponsTable() {
        Table model = new Table();
        TableHeader header = new TableHeader(5);
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernWeaponsDealerDialog.weaponType", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernWeaponsDealerDialog.dealer", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.BaseTradeDialog.buy", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.BaseTradeDialog.sell", new Object[0], this.locale.getCurrentLocal())));
        Text storageHeader = new Text();
        storageHeader.getStyleClass().add((Object)"dialogText");
        storageHeader.textProperty().bind((ObservableValue)this.storageDestinationBinding);
        header.add((ITableCell)new ControlTableCell((Node)storageHeader));
        header.setAligenment(0, HPos.CENTER);
        header.setAligenment(1, HPos.CENTER);
        header.setAligenment(2, HPos.CENTER);
        header.setAligenment(3, HPos.CENTER);
        header.setAligenment(4, HPos.CENTER);
        model.setHeader(header);
        model.setAligenment(0, HPos.RIGHT);
        model.setAligenment(1, HPos.CENTER);
        model.setAligenment(2, HPos.CENTER);
        model.setAligenment(3, HPos.CENTER);
        model.setAligenment(4, HPos.CENTER);
        model.setColumnWidth(new Integer[]{100, 70, 70, 70, 100});
        for (EWeapon weapon : this.weapons) {
            IntegerBinding storedAmount = this.getAmountStoredWeapons(weapon);
            IntegerBinding amountToSell = this.getAmountBinding(storedAmount);
            ReadOnlyIntegerProperty dealerOwnedAmount = this.weaponsDealer.amountAvailableProperty(weapon);
            TableRow row = new TableRow();
            row.add((ITableCell)new StaticTextTableCell(this.translator.getLocalDisplayName(weapon)));
            Text dealerAmount = new Text();
            dealerAmount.getStyleClass().add((Object)"dialogText");
            dealerAmount.textProperty().bind((ObservableValue)dealerOwnedAmount.asString());
            row.add((ITableCell)new ControlTableCell((Node)dealerAmount));
            OpenPatricianSmallWaxButton buyButton = new OpenPatricianSmallWaxButton("");
            buyButton.getStyleClass().add((Object)"actionButton");
            buyButton.setId("buy" + weapon);
            buyButton.setDisable(this.storage == null);
            IntegerBinding buyPriceBinding = this.buyPriceBinding(this.movableAmount, weapon);
            buyButton.textProperty().bind((ObservableValue)buyPriceBinding.asString());
            buyButton.setOnAction(mouseEvent -> {
                if (this.storage != null) {
                    try {
                        if (dealerOwnedAmount.get() > 0) {
                            int amountToBuy = this.transferUtil.calculateAvailableAmount(this.movableAmount, dealerOwnedAmount.get());
                            int affordableAmount = this.computablePrice.calculateAffordableAmount((ITradable)weapon, dealerOwnedAmount.get(), amountToBuy, this.city.getPlayer().getCompany().getCash());
                            int avgPrice = buyPriceBinding.get();
                            this.city.getPlayer().getCompany().updateCash((long)(-affordableAmount * avgPrice));
                            this.storage.update((IWeapon)weapon, affordableAmount);
                            this.weaponsDealer.move((IWeapon)weapon, -amountToBuy);
                            storedAmount.invalidate();
                        }
                    }
                    catch (RuntimeException e) {
                        this.logger.error("Failed to buy from weapons dealer", (Throwable)e);
                    }
                }
            });
            row.add((ITableCell)new ControlTableCell((Node)buyButton));
            OpenPatricianSmallWaxButton sellButton = new OpenPatricianSmallWaxButton("");
            sellButton.getStyleClass().add((Object)"actionButton");
            IntegerBinding sellPriceBinding = this.sellPriceBinding(weapon, amountToSell);
            sellButton.textProperty().bind((ObservableValue)sellPriceBinding.asString());
            sellButton.setOnAction(mouseEvent -> {
                try {
                    int amount = amountToSell.get();
                    int avgPrice = sellPriceBinding.get();
                    this.city.getPlayer().getCompany().updateCash((long)(amount * avgPrice));
                    this.storage.update((IWeapon)weapon, -amount);
                    this.weaponsDealer.move((IWeapon)weapon, amount);
                    storedAmount.invalidate();
                }
                catch (RuntimeException e) {
                    this.logger.error("Failed to sell to weapons dealer", (Throwable)e);
                }
            });
            row.add((ITableCell)new ControlTableCell((Node)sellButton));
            Text amountStored = new Text();
            amountStored.getStyleClass().add((Object)"dialogText");
            amountStored.textProperty().bind((ObservableValue)storedAmount.asString());
            row.add((ITableCell)new ControlTableCell((Node)amountStored));
            model.add(row);
        }
        GridPane pane = this.dialogUtil.createGridPaneFromModel(model);
        pane.getStyleClass().add((Object)"tableFont");
        pane.setLayoutX(30.0);
        pane.setLayoutY(350.0);
        return pane;
    }

    private void initStorageDestionationBinding() {
        if (this.storageDestinationBinding == null) {
            this.storageDestinationBinding = new StringBinding(){

                protected String computeValue() {
                    return TavernWeaponsDealerDialog.this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernWeaponsDealerDialog.tradingOffice", new Object[0], TavernWeaponsDealerDialog.this.locale.getCurrentLocal());
                }
            };
        }
    }

    private IntegerBinding getAmountStoredWeapons(final EWeapon weapon) {
        return new IntegerBinding(){
            {
                if (TavernWeaponsDealerDialog.this.storage != null) {
                    super.bind(new Observable[]{TavernWeaponsDealerDialog.this.storage.getWeaponProperty((IWeapon)weapon)});
                }
            }

            protected int computeValue() {
                if (TavernWeaponsDealerDialog.this.storage != null) {
                    return TavernWeaponsDealerDialog.this.storage.getWeapon((IWeapon)weapon);
                }
                return 0;
            }
        };
    }

    private IntegerBinding getAmountBinding(final IntegerBinding maxAmount) {
        return new IntegerBinding(){
            {
                super.bind(new Observable[]{TavernWeaponsDealerDialog.this.movableAmount, maxAmount});
            }

            protected int computeValue() {
                return TavernWeaponsDealerDialog.this.transferUtil.calculateAvailableAmount(TavernWeaponsDealerDialog.this.movableAmount, maxAmount.get());
            }
        };
    }

    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_TAVERN);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }

    public IntegerBinding buyPriceBinding(final ObjectProperty<ETransferAmount> amount, final EWeapon weapon) {
        return new IntegerBinding(){
            {
                super.bind(new Observable[]{TavernWeaponsDealerDialog.this.weaponsDealer.amountAvailableProperty(weapon), amount, TavernWeaponsDealerDialog.this.city.getPlayer().getCompany().cashProperty()});
            }

            protected int computeValue() {
                int availableAmount = TavernWeaponsDealerDialog.this.weaponsDealer.amountAvailableProperty(weapon).get();
                int buyAmount = TavernWeaponsDealerDialog.this.transferUtil.calculateAvailableAmount(amount, availableAmount);
                int affordableAmount = TavernWeaponsDealerDialog.this.computablePrice.calculateAffordableAmount((ITradable)weapon, availableAmount, buyAmount, TavernWeaponsDealerDialog.this.city.getPlayer().getCompany().getCash());
                if (affordableAmount > 0) {
                    return TavernWeaponsDealerDialog.this.computablePrice.buyPrice((ITradable)weapon, (ReadOnlyIntegerProperty)new SimpleIntegerProperty(availableAmount), (IntegerBinding)new StaticIntegerBinding(affordableAmount));
                }
                return 0;
            }
        };
    }

    public IntegerBinding sellPriceBinding(final EWeapon weapon, final IntegerBinding amountToSell) {
        return new IntegerBinding(){
            {
                super.bind(new Observable[]{TavernWeaponsDealerDialog.this.weaponsDealer.amountAvailableProperty(weapon), amountToSell});
            }

            protected int computeValue() {
                if (amountToSell.get() > 0) {
                    int availableAmount = TavernWeaponsDealerDialog.this.weaponsDealer.amountAvailableProperty(weapon).getValue();
                    return TavernWeaponsDealerDialog.this.computablePrice.sellPrice((ITradable)weapon, (ReadOnlyIntegerProperty)new SimpleIntegerProperty(availableAmount), amountToSell);
                }
                return 0;
            }
        };
    }

    static /* synthetic */ IntegerProperty access$000(TavernWeaponsDealerDialog x0) {
        return x0.currentStorageIndex;
    }
}

