/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.event.handler.impl;

import ch.sahits.game.openpatrician.display.event.data.PatrolInternalState;
import ch.sahits.game.openpatrician.display.event.handler.IAttackListener;
import ch.sahits.game.openpatrician.event.data.ShipAttackEvent;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
class AttackListener
implements IAttackListener {
    private final IShip ship;
    private final PatrolInternalState state;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;

    public AttackListener(IShip ship, PatrolInternalState state) {
        this.ship = ship;
        this.state = state;
    }

    @PostConstruct
    private void initializeEventBus() {
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    public void unregisterEventBus() {
        this.clientServerEventBus.unregister((Object)this);
    }

    @Subscribe
    public void handleShipAttack(ShipAttackEvent event) {
        if (event.getAttackedShip().equals(this.ship)) {
            this.state.incAttackCounter();
        }
    }
}

