/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.javafx;

import ch.sahits.game.openpatrician.display.gameplay.impl.EScene;
import ch.sahits.game.openpatrician.display.javafx.IDialogContoller;
import ch.sahits.game.openpatrician.display.javafx.ISceneEventHandler;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardClose;
import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ObjectPropertyType;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.HANDLER})
public class LoanerSceneEventHandler
implements ISceneEventHandler {
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @ObjectPropertyType(value=EScene.class)
    private ObjectProperty<EScene> currentScene = new SimpleObjectProperty((Object)this, "currentScene", (Object)EScene.PORT);
    private IDialogContoller dialogContoller;

    @Override
    public ObjectProperty<EScene> currentSceneProperty() {
        return this.currentScene;
    }

    @Override
    public void setDialogContoller(IDialogContoller dialogContoller) {
        this.dialogContoller = dialogContoller;
    }

    @Override
    public void handleEvent(Object eventNotice) {
        ViewChangeCityPlayerProxyJFX cityProxy;
        Preconditions.checkNotNull((Object)this.dialogContoller, (Object)"Dialog controller must be initialized first");
        if (eventNotice instanceof ViewChangeCityPlayerProxyJFX && (cityProxy = (ViewChangeCityPlayerProxyJFX)eventNotice).getViewChangeEvent() == EViewChangeEvent.MAIN_VIEW_PORT) {
            this.clientEventBus.post((Object)new NoticeBoardClose());
            this.currentScene.set((Object)EScene.PORT);
            this.dialogContoller.changeScene();
        }
        if (eventNotice instanceof EDialogType) {
            this.dialogContoller.replaceDialog((EDialogType)eventNotice, new Object[0]);
        }
    }
}

