/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.javafx;

import ch.sahits.game.openpatrician.display.gameplay.impl.EScene;
import ch.sahits.game.openpatrician.display.javafx.ArmorySceneEventHandler;
import ch.sahits.game.openpatrician.display.javafx.ChurchSceneEventHandler;
import ch.sahits.game.openpatrician.display.javafx.CityHallSceneEventHandler;
import ch.sahits.game.openpatrician.display.javafx.GuildSceneEventHandler;
import ch.sahits.game.openpatrician.display.javafx.IDialogContoller;
import ch.sahits.game.openpatrician.display.javafx.ISceneEventHandler;
import ch.sahits.game.openpatrician.display.javafx.LoanerSceneEventHandler;
import ch.sahits.game.openpatrician.display.javafx.MarketSceneEventHandler;
import ch.sahits.game.openpatrician.display.javafx.PortSceneEventHandler;
import ch.sahits.game.openpatrician.display.javafx.SeamapSceneHandler;
import ch.sahits.game.openpatrician.display.javafx.ShipyardSceneEventHandler;
import ch.sahits.game.openpatrician.display.javafx.TavernSceneEventHandler;
import ch.sahits.game.openpatrician.display.javafx.control.ViewStatus;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ObjectPropertyType;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class SceneEventHandlerFactory {
    @ObjectPropertyType(value=EScene.class)
    private ObjectProperty<EScene> currentScene = new SimpleObjectProperty((Object)this, "currentScene", (Object)EScene.PORT);
    @Autowired
    private PortSceneEventHandler portSceneHandler;
    @Autowired
    private MarketSceneEventHandler marketSceneHandler;
    @Autowired
    private ShipyardSceneEventHandler shipyardSceneHandler;
    @Autowired
    private TavernSceneEventHandler tavernSceneHandler;
    @Autowired
    private CityHallSceneEventHandler cityHallSceneEventHandler;
    @Autowired
    private LoanerSceneEventHandler loanerSceneEventHandler;
    @Autowired
    private ChurchSceneEventHandler churchSceneEventHandler;
    @Autowired
    private SeamapSceneHandler seamapSceneEventHandler;
    @Autowired
    private GuildSceneEventHandler guildSceneEventHandler;
    @Autowired
    private ArmorySceneEventHandler armorySceneEventHandler;
    @Autowired
    private ViewStatus viewStatus;

    @PostConstruct
    private void initializeBinding() {
        this.portSceneHandler.currentSceneProperty().bindBidirectional(this.currentScene);
        this.marketSceneHandler.currentSceneProperty().bindBidirectional(this.currentScene);
        this.shipyardSceneHandler.currentSceneProperty().bindBidirectional(this.currentScene);
        this.tavernSceneHandler.currentSceneProperty().bindBidirectional(this.currentScene);
        this.cityHallSceneEventHandler.currentSceneProperty().bindBidirectional(this.currentScene);
        this.loanerSceneEventHandler.currentSceneProperty().bindBidirectional(this.currentScene);
        this.churchSceneEventHandler.currentSceneProperty().bindBidirectional(this.currentScene);
        this.seamapSceneEventHandler.currentSceneProperty().bindBidirectional(this.currentScene);
        this.guildSceneEventHandler.currentSceneProperty().bindBidirectional(this.currentScene);
        this.armorySceneEventHandler.currentSceneProperty().bindBidirectional(this.currentScene);
    }

    public ObjectProperty<EScene> currentSceneProperty() {
        return this.currentScene;
    }

    public void setUpDialogController(IDialogContoller controller) {
        this.portSceneHandler.setDialogContoller(controller);
        this.marketSceneHandler.setDialogContoller(controller);
        this.shipyardSceneHandler.setDialogContoller(controller);
        this.tavernSceneHandler.setDialogContoller(controller);
        this.cityHallSceneEventHandler.setDialogContoller(controller);
        this.loanerSceneEventHandler.setDialogContoller(controller);
        this.churchSceneEventHandler.setDialogContoller(controller);
        this.seamapSceneEventHandler.setDialogContoller(controller);
        this.guildSceneEventHandler.setDialogContoller(controller);
        this.armorySceneEventHandler.setDialogContoller(controller);
        this.viewStatus.setDialogContoller(controller);
    }

    public ISceneEventHandler getSceneEventHandler() {
        switch ((EScene)((Object)this.currentScene.get())) {
            case PORT: {
                return this.portSceneHandler;
            }
            case MARKET: {
                return this.marketSceneHandler;
            }
            case SHIPYARD: {
                return this.shipyardSceneHandler;
            }
            case TAVERN: {
                return this.tavernSceneHandler;
            }
            case CITY_HALL: {
                return this.cityHallSceneEventHandler;
            }
            case LOANER: {
                return this.loanerSceneEventHandler;
            }
            case CHURCH: {
                return this.churchSceneEventHandler;
            }
            case GUILD: {
                return this.guildSceneEventHandler;
            }
            case SEAMAP: {
                return this.seamapSceneEventHandler;
            }
            case ARMORY: {
                return this.armorySceneEventHandler;
            }
        }
        throw new IllegalStateException("Unsupported scene: " + this.currentScene.get());
    }
}

