/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.javafx.control;

import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.OpenPaticianApplicationWindow;
import ch.sahits.game.openpatrician.display.SceneChangeable;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.javafx.event.WrappedDialogType;
import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN, EClassCategory.JAVAFX})
public class SubMenu
extends Group {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    @Qualifier(value="xmlImageLoader")
    private IDataImageLoader imageLoader;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private ShipService shipService;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private ApplicationContext context;
    private SceneChangeable sceneChangeable;
    private HBox iconBar;

    public SubMenu() {
        this.setManaged(false);
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource(((Object)((Object)this)).getClass().getSimpleName() + ".css").toExternalForm());
    }

    @PreDestroy
    private void unregister() {
        this.clientEventBus.unregister((Object)this);
    }

    @PostConstruct
    private void initializeControls() {
        this.clientEventBus.register((Object)this);
        this.sceneChangeable = OpenPaticianApplicationWindow.getApplication();
        this.iconBar = new HBox(2.0);
        this.iconBar.setLayoutX(2.0);
        this.iconBar.setLayoutY(6.0);
        this.getChildren().addAll((Object[])new Node[]{this.iconBar});
    }

    private void clearIcons() {
        this.iconBar.getChildren().clear();
    }

    private void setupShipSubNavigation() {
        Image wareImg = this.imageLoader.getImage("icons/32/icon_barrel");
        Image sailorImg = this.imageLoader.getImage("icons/32/icon_head");
        Image weaponImg = this.imageLoader.getImage("icons/32/bombard-icon");
        Image convoyImg = this.imageLoader.getImage("icons/32/icon_convoy");
        Image leaveConvoyImg = this.imageLoader.getImage("icons/32/icon_leave_convoy");
        Image joinConvoyImg = this.imageLoader.getImage("icons/32/icon_join_convoy");
        Image autoTradeImg = this.imageLoader.getImage("icons/32/icon_autotrade");
        ImageView wareGraphic = new ImageView(wareImg);
        ImageView sailorGraphic = new ImageView(sailorImg);
        ImageView weaponGraphic = new ImageView(weaponImg);
        ImageView convoyGraphic = new ImageView(convoyImg);
        ImageView convoyJoinLeaveGraphic = new ImageView(joinConvoyImg);
        if (this.inConvoy().get()) {
            convoyJoinLeaveGraphic.setImage(leaveConvoyImg);
        } else {
            convoyJoinLeaveGraphic.setImage(joinConvoyImg);
        }
        ImageView autoTradeGraphic = new ImageView(autoTradeImg);
        Label wareLbl = new Label();
        wareLbl.setGraphic((Node)wareGraphic);
        Label sailorLbl = new Label();
        sailorLbl.setGraphic((Node)sailorGraphic);
        Label weaponLbl = new Label();
        weaponLbl.setGraphic((Node)weaponGraphic);
        BooleanBinding disableWeapon = new BooleanBinding(){

            protected boolean computeValue() {
                return !(SubMenu.this.viewState.getCurrentCityProxy().get().getActiveShip() instanceof IShip);
            }
        };
        weaponLbl.disableProperty().bind((ObservableValue)disableWeapon);
        weaponLbl.setOnMouseReleased(evt -> {
            ICityPlayerProxyJFX proxy = this.viewState.getCurrentCityProxy().get();
            if (proxy.getActiveShip() instanceof IShip) {
                Object[] args = new Object[]{EDialogType.SHIP_INFO};
                Runnable runnable1 = (Runnable)this.context.getBean("viewChangeActionRunnable", args);
                IShip ship = (IShip)proxy.getActiveShip();
                proxy.activateShip((INavigableVessel)ship);
                runnable1.run();
            }
        });
        Label convoyLbl = new Label();
        convoyLbl.setGraphic((Node)convoyGraphic);
        convoyLbl.disableProperty().bind((ObservableValue)this.inConvoy().not());
        Label convoyJoinLeaveLbl = new Label();
        convoyJoinLeaveLbl.setGraphic((Node)convoyJoinLeaveGraphic);
        this.setupConvoyJoinLeaveLabel(leaveConvoyImg, joinConvoyImg, convoyJoinLeaveGraphic, convoyJoinLeaveLbl, this.inConvoy().getValue());
        this.inConvoy().addListener((observable, oldValue, newValue) -> this.setupConvoyJoinLeaveLabel(leaveConvoyImg, joinConvoyImg, convoyJoinLeaveGraphic, convoyJoinLeaveLbl, (Boolean)newValue));
        Label autoTradeLbl = new Label();
        autoTradeLbl.setGraphic((Node)autoTradeGraphic);
        autoTradeLbl.disableProperty().bind((ObservableValue)this.isOrlegCapable().not());
        this.iconBar.getChildren().addAll((Object[])new Node[]{wareLbl, sailorLbl, weaponLbl, convoyLbl, convoyJoinLeaveLbl, autoTradeLbl});
    }

    private void setupConvoyJoinLeaveLabel(Image leaveConvoyImg, Image joinConvoyImg, ImageView convoyJoinLeaveGraphic, Label convoyJoinLeaveLbl, Boolean newValue) {
        ICityPlayerProxyJFX proxy = this.viewState.getCurrentCityProxy().get();
        INavigableVessel vessel = proxy.getActiveShip();
        if (newValue.booleanValue()) {
            convoyJoinLeaveGraphic.setImage(leaveConvoyImg);
            if (vessel instanceof IShip) {
                IShip ship = (IShip)vessel;
                IConvoy convoy = (IConvoy)ship.parentShipProperty().get();
                WrappedDialogType wrapper = new WrappedDialogType(EDialogType.LEAVE_CONVOY, new Object[]{convoy, ship});
                Runnable run = (Runnable)this.context.getBean("viewChangeWrappedRunnable", new Object[]{wrapper});
                convoyJoinLeaveLbl.setOnMouseReleased(evt -> {
                    proxy.activateShip(vessel);
                    run.run();
                });
            } else {
                convoyJoinLeaveLbl.setOnMouseReleased(evt -> this.openConvoyDialog(proxy, vessel));
            }
        } else {
            convoyJoinLeaveGraphic.setImage(joinConvoyImg);
            convoyJoinLeaveLbl.setOnMouseReleased(evt -> this.openConvoyDialog(proxy, vessel));
        }
    }

    private void openConvoyDialog(ICityPlayerProxyJFX proxy, INavigableVessel vessel) {
        Object[] args = new Object[]{EDialogType.SHIP_CONVOY};
        Runnable runnable1 = (Runnable)this.context.getBean("viewChangeActionRunnable", args);
        proxy.activateShip(vessel);
        runnable1.run();
    }

    @Subscribe
    public void handleNoticeBoardChange(NoticeBoardUpdate event) {
        ViewChangeCityPlayerProxyJFX proxy = (ViewChangeCityPlayerProxyJFX)event.getProxy();
        Platform.runLater(() -> {
            try {
                this.clearIcons();
                if (proxy.getViewChangeEvent() == EViewChangeEvent.NOTICE_SHIP_SELECTION) {
                    this.setupShipSubNavigation();
                }
            }
            catch (RuntimeException e) {
                this.logger.error("Failed to display the ship navigation sub menu", (Throwable)e);
            }
        });
    }

    private BooleanBinding inConvoy() {
        return new BooleanBinding(){
            {
                if (SubMenu.this.viewState.getCurrentCityProxy().isPresent()) {
                    ObjectProperty activeVessel = SubMenu.this.viewState.getCurrentCityProxy().get().activeShipProperty();
                    super.bind(new Observable[]{activeVessel});
                    if (activeVessel.get() != null) {
                        activeVessel.addListener((observable, oldValue, newValue) -> {
                            if (oldValue instanceof IShip) {
                                super.unbind(new Observable[]{((IShip)oldValue).parentShipProperty()});
                            }
                            if (newValue instanceof IShip) {
                                super.bind(new Observable[]{((IShip)newValue).parentShipProperty()});
                            }
                        });
                    }
                }
            }

            protected boolean computeValue() {
                INavigableVessel activeShip = SubMenu.this.viewState.getCurrentCityProxy().get().getActiveShip();
                if (activeShip == null) {
                    return false;
                }
                if (activeShip instanceof IShip) {
                    return ((IShip)activeShip).parentShipProperty().get() != null;
                }
                return false;
            }
        };
    }

    private BooleanBinding isOrlegCapable() {
        return new BooleanBinding(){
            {
                if (SubMenu.this.viewState.getCurrentCityProxy().isPresent()) {
                    ObjectProperty activeVessel = SubMenu.this.viewState.getCurrentCityProxy().get().activeShipProperty();
                    super.bind(new Observable[]{activeVessel});
                }
            }

            protected boolean computeValue() {
                INavigableVessel activeShip = SubMenu.this.viewState.getCurrentCityProxy().get().getActiveShip();
                if (activeShip == null) {
                    return false;
                }
                if (activeShip instanceof IShip) {
                    return SubMenu.this.shipService.isOrlegCapable((IShip)activeShip, SubMenu.this.viewState.getCurrentCityProxy().get().getCity());
                }
                return false;
            }
        };
    }
}

