/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.notice;

import ch.sahits.game.event.data.ClockTickPostDayChange;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.display.javafx.MainGameView;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.NavigationStateChange;
import ch.sahits.game.openpatrician.event.NoticeBoardClose;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.event.data.NoticeBoardPersistentClose;
import ch.sahits.game.openpatrician.javafx.control.NoticeBoard;
import ch.sahits.game.openpatrician.javafx.dialog.Dialog;
import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.javafx.model.ENoticeBoardType;
import ch.sahits.game.openpatrician.javafx.model.NoticeBoardMenu;
import ch.sahits.game.openpatrician.javafx.model.NoticeBoardMenuEntry;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardMenuProvider;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.event.PersonLeavesTavernEvent;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.people.IContractBroker;
import ch.sahits.game.openpatrician.model.people.IInformant;
import ch.sahits.game.openpatrician.model.people.IPerson;
import ch.sahits.game.openpatrician.model.people.IPirate;
import ch.sahits.game.openpatrician.model.people.ISailors;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.people.ITrader;
import ch.sahits.game.openpatrician.model.people.ITraveler;
import ch.sahits.game.openpatrician.model.people.IWeaponsDealer;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Iterator;
import java.util.LinkedList;
import javafx.application.Platform;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class OpenPatricianNoticeBoard
extends NoticeBoard {
    static final Logger logger = LogManager.getLogger(OpenPatricianNoticeBoard.class);
    private ICityPlayerProxyJFX lastProxy;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="timerEventBus")
    private AsyncEventBus timerEventBus;
    @Autowired
    private ApplicationContext context;
    private MainGameView mainGameView;
    private NoticeBoardMenuProvider menuProvider;

    @PostConstruct
    private void initializeEventRegistration() {
        this.clientServerEventBus.register((Object)this);
        this.clientEventBus.register((Object)this);
        this.timerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.clientServerEventBus.unregister((Object)this);
        this.clientEventBus.unregister((Object)this);
        this.timerEventBus.unregister((Object)this);
    }

    @Subscribe
    public void handleNoticeBoardUpdate(NoticeBoardUpdate event) {
        ViewChangeCityPlayerProxyJFX proxy = (ViewChangeCityPlayerProxyJFX)event.getProxy();
        this.lastProxy = proxy;
        if (proxy.getViewChangeEvent() == EViewChangeEvent.NOTICE_HIDE) {
            this.clearNoticeBoardOfSceneTiedMenu(proxy);
        } else {
            this.updateNoticeBoard(proxy, this.map((EViewChangeEvent)((ViewChangeCityPlayerProxyJFX)event.getProxy()).getViewChangeEvent()));
        }
    }

    @Subscribe
    public void handleNoticeBoardClosePersistent(NoticeBoardPersistentClose event) {
        boolean needsUpdate = false;
        block0 : switch (event.getBoardToBeClosed()) {
            case MESSAGES: {
                Iterator iterator = this.noticeBoardMenu.iterator();
                while (iterator.hasNext()) {
                    NoticeBoardMenu menu = (NoticeBoardMenu)iterator.next();
                    if (menu.getType() != ENoticeBoardType.MESSAGE) continue;
                    iterator.remove();
                    needsUpdate = true;
                    break block0;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("The persistent closing for " + event.getBoardToBeClosed() + " is not implemented");
            }
        }
        ViewChangeCityPlayerProxyJFX proxy = (ViewChangeCityPlayerProxyJFX)event.getProxy();
        this.updateAfterStackClearing(proxy, needsUpdate);
    }

    @Subscribe
    public void updateDisplayMessages(DisplayMessage message) {
        EViewChangeEvent viewChange;
        if (this.lastProxy instanceof ViewChangeCityPlayerProxyJFX && (viewChange = (EViewChangeEvent)((ViewChangeCityPlayerProxyJFX)this.lastProxy).getViewChangeEvent()) == EViewChangeEvent.MESSAGES) {
            Platform.runLater(() -> this.updateNoticeBoard((ViewChangeCityPlayerProxyJFX)this.lastProxy, ENoticeBoardType.MESSAGE));
        }
    }

    @Subscribe
    public void handleNavigationChange(NavigationStateChange event) {
        switch (event.getChange()) {
            case DISABLE_NAVIGATION: {
                this.disableNavigationItems();
                break;
            }
            case ENABLE_NAVIGATION: {
                this.enableNavigationItems();
                break;
            }
            default: {
                logger.info("Not interested in navigation change event: " + event.getChange());
            }
        }
    }

    private void disableNavigationItems() {
        ((NoticeBoardMenu)this.noticeBoardMenu.getLast()).disableAll();
    }

    private void enableNavigationItems() {
        ((NoticeBoardMenu)this.noticeBoardMenu.getLast()).enableAll();
    }

    private void updateNoticeBoard(ViewChangeCityPlayerProxyJFX proxy, ENoticeBoardType newType) {
        if (this.menuProvider == null) {
            this.initializeMenuProvider();
        }
        if (this.noticeBoardMenu.isEmpty()) {
            NoticeBoardMenu newMenu = this.menuProvider.createMenu(newType, (ICityPlayerProxyJFX)proxy);
            Platform.runLater(() -> this.addMenu(newMenu));
        } else {
            ENoticeBoardType type = ((NoticeBoardMenu)this.noticeBoardMenu.getLast()).getType();
            if (type == newType) {
                Platform.runLater(() -> {
                    NoticeBoardMenu updatedMenu = this.menuProvider.createMenu(type, (ICityPlayerProxyJFX)proxy);
                    Dialog dialog = this.mainGameView.getDialog();
                    if (dialog != null) {
                        EDialogType dialogType = dialog.getDialogType();
                        for (NoticeBoardMenuEntry entry : updatedMenu.getMenuEntries()) {
                            if (entry.getDialogType() == null || entry.getDialogType() != dialogType) continue;
                            updatedMenu.deselctAll();
                            entry.setSelected(true);
                            break;
                        }
                    }
                    this.reset(updatedMenu);
                });
            } else {
                NoticeBoardMenu newMenu = this.menuProvider.createMenu(newType, (ICityPlayerProxyJFX)proxy);
                if (type.isTiedToScene() && newType.isTiedToScene()) {
                    this.closeNoticeBoard();
                    this.addMenu(newMenu);
                } else {
                    this.addMenu(newMenu);
                }
            }
        }
    }

    private void initializeMenuProvider() {
        this.menuProvider = (NoticeBoardMenuProvider)this.context.getBean(NoticeBoardMenuProvider.class);
        this.mainGameView = (MainGameView)this.context.getBean(MainGameView.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void handlePersonLeaves(PersonLeavesTavernEvent event) {
        LinkedList linkedList = this.noticeBoardMenu;
        synchronized (linkedList) {
            if (!this.noticeBoardMenu.isEmpty() && this.lastProxy.getCity().equals(event.getCity())) {
                ENoticeBoardType type = ((NoticeBoardMenu)this.noticeBoardMenu.getLast()).getType();
                if (this.lastProxy != null && this.lastProxy instanceof ViewChangeCityPlayerProxyJFX && type == ENoticeBoardType.TAVERN) {
                    if (this.mainGameView != null) {
                        Dialog dialog = this.mainGameView.getDialog();
                        EDialogType mappedDialogType = this.map(event.getPerson());
                        if (dialog != null && dialog.getDialogType() == mappedDialogType) {
                            ((CloseButtonDialog)dialog).executeOnCloseButtonClicked();
                        }
                    }
                    this.updateNoticeBoard((ViewChangeCityPlayerProxyJFX)this.lastProxy, type);
                }
            }
        }
    }

    private EDialogType map(IPerson person) {
        if (person instanceof ISideRoomPerson) {
            return EDialogType.TAVERN_SIDE_ROOM;
        }
        if (person instanceof ICaptain) {
            return EDialogType.TAVERN_CAPTAIN;
        }
        if (person instanceof ISailors) {
            return EDialogType.TAVERN_SAILORS;
        }
        if (person instanceof IWeaponsDealer) {
            return EDialogType.TAVERN_WEAPONS_DEALER;
        }
        if (person instanceof ITraveler) {
            return EDialogType.TAVERN_TRAVELER;
        }
        if (person instanceof ITrader) {
            return EDialogType.TAVERN_TRADER;
        }
        if (person instanceof IContractBroker) {
            return null;
        }
        if (person instanceof IPirate) {
            return EDialogType.TAVERN_PIRATE;
        }
        if (person instanceof IInformant) {
            return EDialogType.TAVERN_INFORMANT_1;
        }
        return null;
    }

    @Subscribe
    public void handleCloseNoticeBoard(NoticeBoardClose event) {
        this.closeNoticeBoard();
    }

    @Subscribe
    public void handleDayChange(ClockTickPostDayChange event) {
        if (!this.noticeBoardMenu.isEmpty()) {
            ENoticeBoardType type = ((NoticeBoardMenu)this.noticeBoardMenu.getLast()).getType();
            if (this.lastProxy != null && type == ENoticeBoardType.TAVERN) {
                Platform.runLater(() -> this.updateNoticeBoard((ViewChangeCityPlayerProxyJFX)this.lastProxy, type));
            }
        }
    }

    private void clearNoticeBoardOfSceneTiedMenu(ViewChangeCityPlayerProxyJFX proxy) {
        boolean needsUpdate = false;
        Iterator iterator = this.noticeBoardMenu.iterator();
        while (iterator.hasNext()) {
            NoticeBoardMenu menu = (NoticeBoardMenu)iterator.next();
            if (!menu.getType().isTiedToScene()) continue;
            iterator.remove();
            needsUpdate = true;
        }
        this.updateAfterStackClearing(proxy, needsUpdate);
    }

    private void updateAfterStackClearing(ViewChangeCityPlayerProxyJFX proxy, boolean needsUpdate) {
        if (needsUpdate) {
            if (this.noticeBoardMenu.isEmpty()) {
                this.closeNoticeBoard();
            } else {
                ENoticeBoardType type = ((NoticeBoardMenu)this.noticeBoardMenu.getLast()).getType();
                Platform.runLater(() -> this.updateNoticeBoard(proxy, type));
            }
        }
    }

    private ENoticeBoardType map(EViewChangeEvent viewChange) {
        switch (viewChange) {
            case NOTICE_MARKET_BOOTH: {
                return ENoticeBoardType.MARKET_PLACE;
            }
            case NOTICE_SHIPYARD: {
                return ENoticeBoardType.SHIPYARD;
            }
            case NOTICE_TAVERN: {
                return ENoticeBoardType.TAVERN;
            }
            case NOTICE_TRADE: {
                return ENoticeBoardType.TRADING;
            }
            case NOTICE_TRADING_OFFICE: {
                return ENoticeBoardType.TRADING_OFFICE;
            }
            case NOTICE_LOANER: {
                return ENoticeBoardType.LOANER;
            }
            case MESSAGES: {
                return ENoticeBoardType.MESSAGE;
            }
            case NOTICE_CITY_HALL_BOARD: {
                return ENoticeBoardType.CITY_HALL_NOTICE_BOARD;
            }
            case NOTICE_CITY_HALL_TREASURY: {
                return ENoticeBoardType.CITY_HALL_MAYORS_OFFICE;
            }
            case NOTICE_CITY_HALL_ALDERMAN: {
                return ENoticeBoardType.CITY_HALL_ALDERMAN_OFFICE;
            }
            case NOTICE_CITY_HALL_MEETINGROOM: {
                return ENoticeBoardType.CITY_HALL_MEETINGROOM;
            }
            case MAIN_VIEW_CHURCH: {
                return ENoticeBoardType.CHURCH;
            }
            case NOTICE_SHIP_SELECTION: {
                return ENoticeBoardType.SHIP_SELECTION;
            }
            case MAIN_VIEW_GUILD: {
                return ENoticeBoardType.GUILD;
            }
            case MAIN_VIEW_ARMORY: {
                return ENoticeBoardType.ARMORY;
            }
        }
        return null;
    }
}

