/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.scene;

import ch.sahits.game.graphic.loaders.IPolygonLoader;
import ch.sahits.game.openpatrician.display.scene.BaseStartupScene;
import ch.sahits.game.openpatrician.display.service.UIFactory;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import ch.sahits.game.openpatrician.utilities.plugin.PluginLoader;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.effect.Effect;
import javafx.scene.effect.PerspectiveTransform;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.layout.VBoxBuilder;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.PROTOTYPE_BEAN})
public class StartupScene
extends BaseStartupScene {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    private IPolygonLoader polygonLoader;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    private boolean withPolygonShading = false;
    @Autowired
    private UIFactory uiFactory;
    @Autowired
    private PluginLoader pluginLoader;
    private Pane labelShapes;
    private VBox verticalLayout;

    public StartupScene() {
        super((Region)new Pane());
        if (System.getProperty("javafx.polygon.shading") != null) {
            this.withPolygonShading = true;
        }
    }

    @Override
    protected String getStyleSheetFilename() {
        return "startscene.css";
    }

    @PostConstruct
    private final void setUpScene() {
        Pane root = this.createBaseSceneLayout();
        this.labelShapes = new Pane();
        Label newGameLbl = new Label(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.StartupScene.newGame", new Object[0], this.locale.getCurrentLocal()));
        Polygon untransformed = this.createPolygonShape("newGame");
        untransformed.hoverProperty().addListener((ChangeListener)new BaseStartupScene.LabelHoverChangeListener(newGameLbl));
        untransformed.setOnMouseClicked(event -> {
            this.pluginLoader.loadPlugins();
            this.changeScene(this.uiFactory.getNewGameScene());
        });
        this.labelShapes.getChildren().add((Object)untransformed);
        Label loadGameLbl = new Label(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.StartupScene.loadGame", new Object[0], this.locale.getCurrentLocal()));
        untransformed = this.createPolygonShape("loadGame");
        untransformed.hoverProperty().addListener((ChangeListener)new BaseStartupScene.LabelHoverChangeListener(loadGameLbl));
        untransformed.setOnMouseClicked(event -> {
            this.pluginLoader.loadPlugins();
            this.changeScene(this.uiFactory.getLoadGameScene());
        });
        this.labelShapes.getChildren().add((Object)untransformed);
        Label optionsLbl = new Label(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.StartupScene.options", new Object[0], this.locale.getCurrentLocal()));
        untransformed = this.createPolygonShape("options");
        untransformed.hoverProperty().addListener((ChangeListener)new BaseStartupScene.LabelHoverChangeListener(optionsLbl));
        this.labelShapes.getChildren().add((Object)untransformed);
        Label creditsLbl = new Label(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.StartupScene.credits", new Object[0], this.locale.getCurrentLocal()));
        untransformed = this.createPolygonShape("credits");
        untransformed.hoverProperty().addListener((ChangeListener)new BaseStartupScene.LabelHoverChangeListener(creditsLbl));
        untransformed.setOnMouseClicked(event -> this.changeScene(this.uiFactory.getCreditsScene()));
        this.labelShapes.getChildren().add((Object)untransformed);
        Label historyLbl = new Label(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.StartupScene.history", new Object[0], this.locale.getCurrentLocal()));
        untransformed = this.createPolygonShape("history");
        untransformed.hoverProperty().addListener((ChangeListener)new BaseStartupScene.LabelHoverChangeListener(historyLbl));
        untransformed.setOnMouseClicked(event -> this.changeScene(this.uiFactory.getHanseaticHistoryScene()));
        this.labelShapes.getChildren().add((Object)untransformed);
        PerspectiveTransform perspectiveTransform = this.createPerspectiveTransform();
        this.verticalLayout = ((VBoxBuilder)((VBoxBuilder)((VBoxBuilder)VBoxBuilder.create().children(new Node[]{newGameLbl, loadGameLbl, optionsLbl, creditsLbl, historyLbl})).spacing(30.0).padding(new Insets(10.0))).effect((Effect)perspectiveTransform)).build();
        Rectangle ph = new Rectangle(root.getWidth(), root.getHeight(), (Paint)Color.TRANSPARENT);
        ph.widthProperty().bind((ObservableValue)root.widthProperty());
        ph.heightProperty().bind((ObservableValue)root.heightProperty());
        AnchorPane ap = new AnchorPane();
        ap.getChildren().add((Object)this.paperScroll);
        AnchorPane.setBottomAnchor((Node)this.paperScroll, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.paperScroll, (Double)0.0);
        ap.getChildren().addAll((Object[])new Node[]{ph});
        root.getChildren().addAll((Object[])new Node[]{ap, this.verticalLayout, this.labelShapes});
        this.heightChange(0.0, root.getHeight());
        this.widthChange(0.0, root.getWidth());
    }

    private Polygon createPolygonShape(String polygonName) {
        List startupPolygons = this.polygonLoader.getPolygon("/polygonDefinition.xml", "startup");
        Polygon untransformed = this.polygonLoader.toJavaFXPolygon(this.polygonLoader.find(startupPolygons, polygonName));
        if (this.withPolygonShading) {
            untransformed.setFill((Paint)Color.DARKGREEN);
            untransformed.setOpacity(0.5);
        } else {
            untransformed.setFill((Paint)Color.TRANSPARENT);
        }
        return untransformed;
    }

    public void heightChange(double oldHeight, double newHeigth) {
        double top = Math.max(newHeigth - this.untransformedHeight - this.labelShapes.getLayoutY() - 7.0, 0.0);
        this.labelShapes.translateYProperty().set(top);
        top = Math.max(newHeigth - this.untransformedHeight - this.verticalLayout.getLayoutY() + 15.0, 0.0);
        this.verticalLayout.translateYProperty().set(top);
    }

    public void widthChange(double oldWidth, double newWidth) {
        double left = Math.max(newWidth - this.untransformedWidth - this.labelShapes.getLayoutX() - 36.0, 0.0);
        this.labelShapes.translateXProperty().set(left);
        left = Math.max(newWidth - this.untransformedWidth - this.verticalLayout.getLayoutX() + 10.0, 0.0);
        this.verticalLayout.translateXProperty().set(left);
    }
}

