/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.service;

import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.graphic.image.IFontLoader;
import ch.sahits.game.graphic.image.impl.FontLoader;
import ch.sahits.game.openpatrician.display.OpenPaticianApplicationWindow;
import ch.sahits.game.openpatrician.display.javafx.MainGameView;
import ch.sahits.game.openpatrician.display.javafx.control.GameStatus;
import ch.sahits.game.openpatrician.display.javafx.control.MainMenu;
import ch.sahits.game.openpatrician.display.javafx.control.MiniMap;
import ch.sahits.game.openpatrician.display.javafx.control.SubMenu;
import ch.sahits.game.openpatrician.display.javafx.control.ViewStatus;
import ch.sahits.game.openpatrician.display.scene.CreditsScene;
import ch.sahits.game.openpatrician.display.scene.HanseaticHistoryScene;
import ch.sahits.game.openpatrician.display.scene.InGameOptionsScene;
import ch.sahits.game.openpatrician.display.scene.LoadGameScene;
import ch.sahits.game.openpatrician.display.scene.MainGameScene;
import ch.sahits.game.openpatrician.display.scene.NewGameScene;
import ch.sahits.game.openpatrician.display.scene.StartupScene;
import ch.sahits.game.openpatrician.display.service.IJavaFXControlLoader;
import ch.sahits.game.openpatrician.javafx.OpenPatricianScene;
import ch.sahits.game.openpatrician.javafx.control.NoticeBoard;
import ch.sahits.game.openpatrician.utilities.IInvalidatable;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.collections.NonReplacableMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class UIFactory
implements IInvalidatable {
    @Autowired
    private ApplicationContext context;
    private final NonReplacableMap<String, OpenPatricianScene> sceneMap = new NonReplacableMap();
    private IJavaFXControlLoader jfxControlLoader;

    @PostConstruct
    private void init() {
        this.jfxControlLoader = new JavaFXControlLoader();
    }

    public IDataImageLoader getXMLImageLoader() {
        return (IDataImageLoader)this.context.getBean("xmlImageLoader");
    }

    public MainGameScene getMainGameScene(double width, double heigth) {
        if (!this.sceneMap.containsKey((Object)"mainGameScene")) {
            this.sceneMap.put((Object)"mainGameScene", (Object)((OpenPatricianScene)this.context.getBean("mainGameScene", new Object[]{width, heigth, this.getXMLImageLoader(), this.jfxControlLoader})));
        }
        return (MainGameScene)((Object)this.sceneMap.get((Object)"mainGameScene"));
    }

    public StartupScene getStartupScene() {
        if (!this.sceneMap.containsKey((Object)"startupScene")) {
            this.sceneMap.put((Object)"startupScene", (Object)((StartupScene)((Object)this.context.getBean("startupScene"))));
        }
        return (StartupScene)((Object)this.sceneMap.get((Object)"startupScene"));
    }

    public HanseaticHistoryScene getHanseaticHistoryScene() {
        if (!this.sceneMap.containsKey((Object)"hanseaticHistoryScene")) {
            this.sceneMap.put((Object)"hanseaticHistoryScene", (Object)((HanseaticHistoryScene)((Object)this.context.getBean("hanseaticHistoryScene"))));
        }
        return (HanseaticHistoryScene)((Object)this.sceneMap.get((Object)"hanseaticHistoryScene"));
    }

    public CreditsScene getCreditsScene() {
        if (!this.sceneMap.containsKey((Object)"creditsScene")) {
            this.sceneMap.put((Object)"creditsScene", (Object)((CreditsScene)((Object)this.context.getBean("creditsScene"))));
        }
        return (CreditsScene)((Object)this.sceneMap.get((Object)"creditsScene"));
    }

    public NewGameScene getNewGameScene() {
        if (!this.sceneMap.containsKey((Object)"newGameScene")) {
            NewGameScene newGameScene = (NewGameScene)((Object)this.context.getBean("newGameScene"));
            newGameScene.setSceneChangeable(OpenPaticianApplicationWindow.getApplication());
            this.sceneMap.put((Object)"newGameScene", (Object)newGameScene);
        }
        return (NewGameScene)((Object)this.sceneMap.get((Object)"newGameScene"));
    }

    public LoadGameScene getLoadGameScene() {
        if (!this.sceneMap.containsKey((Object)"loadGameScene")) {
            LoadGameScene loadGameScene = (LoadGameScene)((Object)this.context.getBean("loadGameScene"));
            loadGameScene.setSceneChangeable(OpenPaticianApplicationWindow.getApplication());
            this.sceneMap.put((Object)"loadGameScene", (Object)loadGameScene);
        }
        return (LoadGameScene)((Object)this.sceneMap.get((Object)"loadGameScene"));
    }

    public InGameOptionsScene getInGameOptionsScene() {
        if (!this.sceneMap.containsKey((Object)"inGameOptionsScene")) {
            this.sceneMap.put((Object)"inGameOptionsScene", (Object)((InGameOptionsScene)((Object)this.context.getBean("inGameOptionsScene"))));
        }
        return (InGameOptionsScene)((Object)this.sceneMap.get((Object)"inGameOptionsScene"));
    }

    public IJavaFXControlLoader getJavaFXControlLoader() {
        return this.jfxControlLoader;
    }

    public void invalidate() {
        Iterator iterator = this.sceneMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry next = (Map.Entry)iterator.next();
            iterator.remove();
        }
    }

    private class JavaFXControlLoader
    implements IJavaFXControlLoader {
        private JavaFXControlLoader() {
        }

        @Override
        public MiniMap getMiniMap() {
            return (MiniMap)((Object)UIFactory.this.context.getBean("miniMap"));
        }

        @Override
        public MainMenu getMainMenu() {
            return (MainMenu)((Object)UIFactory.this.context.getBean("mainMenu"));
        }

        @Override
        public SubMenu getSubMenu() {
            return (SubMenu)((Object)UIFactory.this.context.getBean("subMenu"));
        }

        @Override
        public NoticeBoard getNoticeBoard() {
            NoticeBoard noticeBoard = (NoticeBoard)UIFactory.this.context.getBean(NoticeBoard.class);
            return noticeBoard;
        }

        @Override
        public ViewStatus getViewStatus() {
            return (ViewStatus)((Object)UIFactory.this.context.getBean("viewStatus"));
        }

        @Override
        public IFontLoader getFontLoader() {
            return (IFontLoader)UIFactory.this.context.getBean(FontLoader.class);
        }

        @Override
        public GameStatus getGameStatus() {
            return (GameStatus)((Object)UIFactory.this.context.getBean(GameStatus.class));
        }

        @Override
        public MainGameView getMainGameView(double width, double heigth) {
            Object[] args = new Object[]{width, heigth};
            return (MainGameView)UIFactory.this.context.getBean("mainGameView", args);
        }
    }
}

