/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.dialog.BaseTradeDialog;
import ch.sahits.game.openpatrician.event.NoticeBoardClose;
import ch.sahits.game.openpatrician.javafx.control.BarrelIconView;
import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.eventbus.AsyncEventBus;
import javafx.beans.Observable;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.text.Text;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class CityShipTradeDialog
extends BaseTradeDialog {
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;

    public CityShipTradeDialog(ICityPlayerProxyJFX city) {
        super(city, EDialogType.PORT_CITY_TO_SHIP);
    }

    @Override
    protected Group createSubTitle(final ICityPlayerProxyJFX city) {
        StringBinding cityPopulation = new StringBinding(){
            {
                super.bind(new Observable[]{city.getCity().getPopulationBinding()});
            }

            protected String computeValue() {
                ICity actualCity = city.getCity();
                return actualCity.getName() + " " + actualCity.getPopulationBinding().asString().get();
            }
        };
        Text cityText = new Text();
        cityText.textProperty().bind((ObservableValue)cityPopulation);
        cityText.getStyleClass().add((Object)"dialogText");
        Group g = new Group();
        g.setManaged(false);
        final INavigableVessel ship = city.getActiveShip();
        BarrelIconView barrel = new BarrelIconView();
        barrel.setLayoutX(174.0);
        barrel.setLayoutY(-12.0);
        StringBinding shipLoad = new StringBinding(){
            {
                super.bind(new Observable[]{ship.getLoadBinding()});
            }

            protected String computeValue() {
                return ship.getLoadBinding().asString().get() + " / " + ship.getLoadableSpace();
            }
        };
        Text shipSpace = new Text();
        shipSpace.textProperty().bind((ObservableValue)shipLoad);
        shipSpace.getStyleClass().add((Object)"dialogText");
        shipSpace.setLayoutX(200.0);
        String shipNameLabel = ship.getName();
        if (ship instanceof IConvoy) {
            shipNameLabel = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.BaseTradeDialog.convoyName", new Object[]{shipNameLabel}, this.locale.getCurrentLocal());
        }
        Text shipName = new Text(shipNameLabel);
        shipName.setWrappingWidth(160.0);
        shipName.getStyleClass().add((Object)"dialogText");
        shipName.setLayoutX(300.0);
        g.getChildren().addAll((Object[])new Node[]{cityText, barrel, shipSpace, shipName});
        return g;
    }

    @Override
    public void executeOnCloseButtonClicked() {
        this.clientEventBus.post((Object)new NoticeBoardClose());
        super.executeOnCloseButtonClicked();
    }
}

