/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog;

import ch.sahits.game.graphic.image.IFontLoader;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.display.javafx.MainGameView;
import ch.sahits.game.openpatrician.event.NoticeBoardClose;
import ch.sahits.game.openpatrician.javafx.control.PaginationV2;
import ch.sahits.game.openpatrician.javafx.control.PaginationV2Builder;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import ch.sahits.game.openpatrician.utilities.model.Text;
import ch.sahits.game.openpatrician.utilities.service.TextParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javafx.geometry.Insets;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.SINGLETON_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class HistoryStandaloneDialog
extends CloseButtonDialog {
    private final Logger logger = LogManager.getLogger(this.getClass());
    protected final ICityPlayerProxyJFX city;
    private final String historyResource;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @Autowired
    @Qualifier(value="resourceReference")
    private MessageSource resources;
    @Autowired
    private TextParser textParser;
    @Autowired
    private IFontLoader fontLoader;
    @Autowired
    private ModelTranslations modelTranslator;

    public HistoryStandaloneDialog(ICityPlayerProxyJFX city, String historyResource) {
        this.city = city;
        this.historyResource = historyResource;
    }

    @PostConstruct
    private void initializeDialog() {
        Text historyText = this.getHistoryText();
        Insets insets = new Insets(15.0, 15.0, 15.0, 30.0);
        Font headerFont = this.fontLoader.createDefaultFont(24);
        Font defaultfont = this.fontLoader.createDefaultFont(18);
        PaginationV2 pagination = PaginationV2Builder.create().backButtonLabel(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.CreditsScene.back", new Object[0], this.locale.getCurrentLocal())).nextButtonLabel(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.CreditsScene.next", new Object[0], this.locale.getCurrentLocal())).text(historyText).contentMaxWidth(458.0).contentMaxHeight(567.0).padding(insets).navigationLabelFont(defaultfont).headerFont(headerFont).paragraphFont(defaultfont).centeredFont(defaultfont).firstLastPageAction(event -> {
            MainGameView mainGameView = (MainGameView)this.getParent();
            mainGameView.closeDialog();
        }).build();
        pagination.setLayoutY(30.0);
        this.getContent().add((Object)pagination);
    }

    private Text getHistoryText() {
        String resourceName = this.resources.getMessage(this.historyResource, new Object[0], this.locale.getCurrentLocal());
        URL url = this.getClass().getClassLoader().getResource(resourceName);
        try {
            InputStream is = url.openStream();
            return this.textParser.parse(is);
        }
        catch (IOException e) {
            this.logger.warn("History text could not be found: " + url.toExternalForm());
            return new Text();
        }
    }

    @Override
    public void executeOnCloseButtonClicked() {
        this.clientEventBus.post((Object)new NoticeBoardClose());
        super.executeOnCloseButtonClicked();
    }
}

