/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.dialog.TabelViewDialog;
import ch.sahits.game.openpatrician.event.NoticeBoardClose;
import ch.sahits.game.openpatrician.javafx.control.CoinPriceAlwaysVisible;
import ch.sahits.game.openpatrician.javafx.model.ControlTableCell;
import ch.sahits.game.openpatrician.javafx.model.ITableCell;
import ch.sahits.game.openpatrician.javafx.model.StaticTextTableCell;
import ch.sahits.game.openpatrician.javafx.model.Table;
import ch.sahits.game.openpatrician.javafx.model.TableHeader;
import ch.sahits.game.openpatrician.javafx.model.TableRow;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IBalanceSheet;
import ch.sahits.game.openpatrician.model.building.IBuilding;
import ch.sahits.game.openpatrician.model.building.ITownHouse;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.building.IWorkShop;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import java.util.List;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TradeOfficeBalanceDialog
extends TabelViewDialog {
    protected final ICityPlayerProxyJFX city;
    @Autowired
    private Date date;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private ModelTranslations modelTranslator;

    public TradeOfficeBalanceDialog(ICityPlayerProxyJFX city) {
        this.city = city;
    }

    private Group createSubTitle() {
        DateBoundStringProperty fromTo = new DateBoundStringProperty(){

            protected String computeValue() {
                return TradeOfficeBalanceDialog.this.modelTranslator.getStartOfWeek(TradeOfficeBalanceDialog.this.date.getCurrentDate()) + " to " + TradeOfficeBalanceDialog.this.modelTranslator.getEndOfWeek(TradeOfficeBalanceDialog.this.date.getCurrentDate());
            }
        };
        Text fromToText = new Text();
        fromToText.textProperty().bind((ObservableValue)fromTo);
        fromToText.getStyleClass().add((Object)"dialogText");
        fromToText.setLayoutX(100.0);
        String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TradeOfficeBalanceDialog.forecast", new Object[0], this.locale.getCurrentLocal());
        Text forecast = new Text(template);
        forecast.getStyleClass().add((Object)"dialogText");
        forecast.setLayoutX(350.0);
        Group g = new Group();
        g.setManaged(false);
        g.getChildren().addAll((Object[])new Node[]{fromToText, forecast});
        return g;
    }

    @PostConstruct
    private void initializeModelAndDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TradeOfficeBalanceDialog.title", new Object[0], this.locale.getCurrentLocal()));
        Group subTitle = this.createSubTitle();
        subTitle.setLayoutX(30.0);
        subTitle.setLayoutY(80.0);
        this.getContent().add((Object)subTitle);
        Table model = this.createModel();
        this.setModel(model);
    }

    private Table createModel() {
        ICity cityModel = this.city.getCity();
        Optional optOffice = this.city.getPlayer().findTradingOffice(cityModel);
        Preconditions.checkArgument((boolean)optOffice.isPresent(), (Object)"The trading office must be present");
        final ITradingOffice office = (ITradingOffice)optOffice.get();
        List workshops = this.city.getPlayer().findBuildings(cityModel, IWorkShop.class);
        List townhouse = this.city.getPlayer().findBuildings(cityModel, ITownHouse.class);
        Table model = new Table();
        TableHeader header = new TableHeader(5);
        header.add((ITableCell)new StaticTextTableCell(""));
        header.add((ITableCell)new StaticTextTableCell(""));
        header.add((ITableCell)new StaticTextTableCell(""));
        header.add((ITableCell)new StaticTextTableCell(""));
        header.add((ITableCell)new StaticTextTableCell(""));
        header.setAligenment(0, HPos.RIGHT);
        header.setAligenment(1, HPos.LEFT);
        header.setAligenment(2, HPos.LEFT);
        header.setAligenment(3, HPos.LEFT);
        header.setAligenment(4, HPos.LEFT);
        model.setHeader(header);
        model.setColumnWidth(new Integer[]{100, 50, 100, 50, 150});
        TableRow row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TradeOfficeBalanceDialog.rentalIncome", new Object[0], this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        DateBoundStringProperty rentalIncomeLastWeek = new DateBoundStringProperty(){

            protected String computeValue() {
                return String.valueOf(office.getBalanceLastWeek().getRentalIncome());
            }
        };
        CoinPriceAlwaysVisible coinPrice = new CoinPriceAlwaysVisible();
        coinPrice.amountProperty().bind((ObservableValue)rentalIncomeLastWeek);
        row.add((ITableCell)new ControlTableCell((Node)coinPrice));
        row.add((ITableCell)new StaticTextTableCell(""));
        DateBoundStringProperty rentalIncomeForecast = new DateBoundStringProperty(){

            protected String computeValue() {
                return String.valueOf(office.getCurrentWeek().getRentalIncome());
            }
        };
        coinPrice = new CoinPriceAlwaysVisible();
        coinPrice.amountProperty().bind((ObservableValue)rentalIncomeForecast);
        row.add((ITableCell)new ControlTableCell((Node)coinPrice));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TradeOfficeBalanceDialog.wages", new Object[0], this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        DateBoundStringProperty wagesIncomeLastWeek = new DateBoundStringProperty(){

            protected String computeValue() {
                return String.valueOf(office.getBalanceLastWeek().getWageCosts());
            }
        };
        coinPrice = new CoinPriceAlwaysVisible();
        coinPrice.amountProperty().bind((ObservableValue)wagesIncomeLastWeek);
        row.add((ITableCell)new ControlTableCell((Node)coinPrice));
        row.add((ITableCell)new StaticTextTableCell(""));
        DateBoundStringProperty wagesIncomeForecast = new DateBoundStringProperty(){

            protected String computeValue() {
                return String.valueOf(office.getBalanceLastWeek().getRentalIncome());
            }
        };
        coinPrice = new CoinPriceAlwaysVisible();
        coinPrice.amountProperty().bind((ObservableValue)wagesIncomeForecast);
        row.add((ITableCell)new ControlTableCell((Node)coinPrice));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TradeOfficeBalanceDialog.propertyTax", new Object[0], this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        DateBoundStringProperty taxLastWeek = new DateBoundStringProperty(){

            protected String computeValue() {
                return String.valueOf(office.getBalanceLastWeek().getPropertyTaxes());
            }
        };
        coinPrice = new CoinPriceAlwaysVisible();
        coinPrice.amountProperty().bind((ObservableValue)taxLastWeek);
        row.add((ITableCell)new ControlTableCell((Node)coinPrice));
        row.add((ITableCell)new StaticTextTableCell(""));
        DateBoundStringProperty taxForecast = new DateBoundStringProperty(){

            protected String computeValue() {
                return String.valueOf(office.getBalanceLastWeek().getPropertyTaxes());
            }
        };
        coinPrice = new CoinPriceAlwaysVisible();
        coinPrice.amountProperty().bind((ObservableValue)taxForecast);
        row.add((ITableCell)new ControlTableCell((Node)coinPrice));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TradeOfficeBalanceDialog.officeTrading", new Object[0], this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        DateBoundStringProperty tradingLastWeek = new DateBoundStringProperty(){

            protected String computeValue() {
                return String.valueOf(office.getBalanceLastWeek().getOfficeTrading());
            }
        };
        coinPrice = new CoinPriceAlwaysVisible();
        coinPrice.amountProperty().bind((ObservableValue)tradingLastWeek);
        row.add((ITableCell)new ControlTableCell((Node)coinPrice));
        row.add((ITableCell)new StaticTextTableCell(""));
        DateBoundStringProperty tradingForecast = new DateBoundStringProperty(){

            protected String computeValue() {
                return String.valueOf(office.getBalanceLastWeek().getOfficeTrading());
            }
        };
        coinPrice = new CoinPriceAlwaysVisible();
        coinPrice.amountProperty().bind((ObservableValue)tradingForecast);
        row.add((ITableCell)new ControlTableCell((Node)coinPrice));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TradeOfficeBalanceDialog.steward", new Object[0], this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        DateBoundStringProperty stewardLastWeek = new DateBoundStringProperty(){

            protected String computeValue() {
                return String.valueOf(office.getBalanceLastWeek().getStewardCost());
            }
        };
        coinPrice = new CoinPriceAlwaysVisible();
        coinPrice.amountProperty().bind((ObservableValue)stewardLastWeek);
        row.add((ITableCell)new ControlTableCell((Node)coinPrice));
        row.add((ITableCell)new StaticTextTableCell(""));
        DateBoundStringProperty stewardForecast = new DateBoundStringProperty(){

            protected String computeValue() {
                return String.valueOf(office.getBalanceLastWeek().getStewardCost());
            }
        };
        coinPrice = new CoinPriceAlwaysVisible();
        coinPrice.amountProperty().bind((ObservableValue)stewardForecast);
        row.add((ITableCell)new ControlTableCell((Node)coinPrice));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TradeOfficeBalanceDialog.other", new Object[0], this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        DateBoundStringProperty otherLastWeek = new DateBoundStringProperty(){

            protected String computeValue() {
                return String.valueOf(office.getBalanceLastWeek().getOtherCosts());
            }
        };
        coinPrice = new CoinPriceAlwaysVisible();
        coinPrice.amountProperty().bind((ObservableValue)otherLastWeek);
        row.add((ITableCell)new ControlTableCell((Node)coinPrice));
        row.add((ITableCell)new StaticTextTableCell(""));
        DateBoundStringProperty otherForecast = new DateBoundStringProperty(){

            protected String computeValue() {
                return String.valueOf(office.getBalanceLastWeek().getOtherCosts());
            }
        };
        coinPrice = new CoinPriceAlwaysVisible();
        coinPrice.amountProperty().bind((ObservableValue)otherForecast);
        row.add((ITableCell)new ControlTableCell((Node)coinPrice));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TradeOfficeBalanceDialog.sum", new Object[0], this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        DateBoundStringProperty sumLastWeek = new DateBoundStringProperty(){

            protected String computeValue() {
                IBalanceSheet bal = office.getBalanceLastWeek();
                int lastWeek = 0;
                lastWeek += bal.getOtherCosts() + bal.getPropertyTaxes() + bal.getStewardCost() + bal.getWageCosts();
                return String.valueOf(lastWeek -= bal.getOfficeTrading() + bal.getRentalIncome());
            }
        };
        coinPrice = new CoinPriceAlwaysVisible();
        coinPrice.amountProperty().bind((ObservableValue)sumLastWeek);
        row.add((ITableCell)new ControlTableCell((Node)coinPrice));
        row.add((ITableCell)new StaticTextTableCell(""));
        DateBoundStringProperty sumForecast = new DateBoundStringProperty(){

            protected String computeValue() {
                int forcast = 0;
                IBalanceSheet bal = office.getCurrentWeek();
                forcast += bal.getOtherCosts() + bal.getPropertyTaxes() + bal.getStewardCost() + bal.getWageCosts();
                return String.valueOf(forcast -= bal.getOfficeTrading() + bal.getRentalIncome());
            }
        };
        coinPrice = new CoinPriceAlwaysVisible();
        coinPrice.amountProperty().bind((ObservableValue)sumForecast);
        row.add((ITableCell)new ControlTableCell((Node)coinPrice));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TradeOfficeBalanceDialog.buildings", new Object[0], this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TradeOfficeBalanceDialog.workshops", new Object[]{workshops.size()}, this.locale.getCurrentLocal())));
        int workers = 0;
        int maxWorkers = 0;
        for (IBuilding building : workshops) {
            workers += ((IWorkShop)building).getWorkers();
            maxWorkers += ((IWorkShop)building).getMaxWorkers();
        }
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TradeOfficeBalanceDialog.workers", new Object[]{workers, maxWorkers}, this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TradeOfficeBalanceDialog.tenements", new Object[]{townhouse.size()}, this.locale.getCurrentLocal())));
        int tenants = 0;
        int maxTenants = 0;
        for (IBuilding building : townhouse) {
            tenants += ((ITownHouse)building).getOccupancy();
            maxTenants += ((ITownHouse)building).getCapacity();
        }
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TradeOfficeBalanceDialog.tenants", new Object[]{tenants, maxTenants}, this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        model.add(row);
        return model;
    }

    @Override
    public void executeOnCloseButtonClicked() {
        this.clientEventBus.post((Object)new NoticeBoardClose());
        super.executeOnCloseButtonClicked();
    }

    private abstract class DateBoundStringProperty
    extends StringBinding {
        private DateBoundStringProperty() {
            super.bind(new Observable[]{TradeOfficeBalanceDialog.this.date.getCurrentDateProperty()});
        }
    }
}

