/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.cityhall;

import ch.sahits.game.event.data.ClockTickDayChange;
import ch.sahits.game.graphic.image.impl.SelectiveCachableXMLImageLoader;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.MapService;
import ch.sahits.game.openpatrician.clientserverinterface.service.ModelStateAccessor;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.IViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.event.data.ElectionWinnerNotification;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianSmallToggableWaxButton;
import ch.sahits.game.openpatrician.javafx.control.PlaceHolder;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DateService;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ECityWall;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.cityhall.EElectionType;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityHall;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.CityWallPetition;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.HeadTaxPetition;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.MilitiaPetition;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.SpecialTaxPetition;
import ch.sahits.game.openpatrician.model.personal.EEconomicCareer;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.personal.ICareer;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TownInfoDialog
extends CloseButtonDialog {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private ModelStateAccessor cityHallAccessor;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private ModelTranslations modelTranslator;
    @Autowired
    private Date date;
    @Autowired
    private MapService cityService;
    @Autowired
    @Qualifier(value="xmlImageLoader")
    private SelectiveCachableXMLImageLoader imageLoader;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="timerEventBus")
    private AsyncEventBus timerEventBus;
    @Autowired
    private DateService dateService;
    private final ICityPlayerProxyJFX city;
    private HBox selectionBox = null;
    private VBox box;
    private boolean displayAtElectionDay = false;

    public TownInfoDialog(ICityPlayerProxyJFX city) {
        this.city = city;
        this.getStylesheets().add((Object)this.getClass().getResource("/styles/base.css").toExternalForm());
        this.getStyleClass().add((Object)"dialog");
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TownInfoNotice.title", new Object[0], this.locale.getCurrentLocal()));
        ICity town = this.city.getCity();
        IHumanPlayer player = this.city.getPlayer();
        this.resetContent(town, (IPlayer)player);
        int actionButtonX = 197;
        OpenPatricianLargeWaxButton action = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TownInfoNotice.petition", new Object[0], this.locale.getCurrentLocal()));
        action.getStyleClass().add((Object)"actionButton");
        action.setOnAction(this.getAction(this.box, action));
        action.setLayoutX(197.0);
        action.setLayoutY(603.0);
        action.setDisable(!this.canPosePetition(town, (IPlayer)player));
        this.getContent().addAll((Object[])new Node[]{action});
        this.clientServerEventBus.register((Object)this);
        this.timerEventBus.register((Object)this);
    }

    private void unregister() {
        this.clientEventBus.unregister((Object)this);
        this.timerEventBus.unregister((Object)this);
    }

    private void resetContent(ICity town, IPlayer player) {
        this.getContent().remove((Object)this.box);
        this.box = this.textFactory.createMultiParagraphContainer();
        ICityHall cityHall = this.cityHallAccessor.getCityHall(town);
        ICitizen mayor = cityHall.getMayor();
        Object[] args = new Object[]{town.getName(), this.modelTranslator.getLocalDisplayDistinctArticle(player.getPersonalData().isMale(), false), mayor.getName() + " " + mayor.getLastName()};
        String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TownInfoNotice.paragraph1", args, this.locale.getCurrentLocal());
        DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
        this.box.getChildren().add((Object)text);
        LocalDateTime electionDate = cityHall.getElectionDate();
        if (this.dateService.isSameDay(electionDate, this.date.getCurrentDate())) {
            template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TownInfoNotice.electionDay", new Object[0], this.locale.getCurrentLocal());
            this.displayAtElectionDay = true;
        } else {
            template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TownInfoNotice.paragraph2", new Object[]{this.modelTranslator.toDisplayString(electionDate)}, this.locale.getCurrentLocal());
            this.displayAtElectionDay = false;
        }
        text = this.textFactory.createDecoratedText(template, new HashMap());
        this.box.getChildren().add((Object)text);
        List candidates = cityHall.getCandidates();
        for (ICitizen candidate : candidates) {
            text = this.getCandidateRow(candidate);
            this.box.getChildren().add((Object)text);
        }
        this.box.getChildren().addAll((Object[])new Node[]{new Label(" "), new Label(" ")});
        HBox row = new HBox(10.0);
        row.setId("candidateship");
        row.setVisible(this.canBeCandidate(player, town));
        template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TownInfoNotice.acceptNomination", new Object[0], this.locale.getCurrentLocal());
        Text question = new Text(template);
        question.getStyleClass().add((Object)"dialog");
        OpenPatricianSmallToggableWaxButton yesButton = new OpenPatricianSmallToggableWaxButton(this.messageSource.getMessage("yes", new Object[0], this.locale.getCurrentLocal()));
        OpenPatricianSmallToggableWaxButton noButton = new OpenPatricianSmallToggableWaxButton(this.messageSource.getMessage("no", new Object[0], this.locale.getCurrentLocal()));
        yesButton.getStylesheets().add((Object)this.getClass().getResource("/styles/base.css").toExternalForm());
        noButton.getStylesheets().add((Object)this.getClass().getResource("/styles/base.css").toExternalForm());
        if (candidates.contains(player)) {
            yesButton.getStyleClass().add((Object)"active");
            noButton.getStyleClass().add((Object)"inactive");
        } else {
            yesButton.getStyleClass().add((Object)"inactive");
            noButton.getStyleClass().add((Object)"inactive");
        }
        yesButton.setOnAction(mouseEvent -> {
            try {
                if (!candidates.contains(player)) {
                    yesButton.getStyleClass().remove((Object)"inactive");
                    yesButton.getStyleClass().add((Object)"active");
                    noButton.getStyleClass().add((Object)"inactive");
                    candidates.add(player);
                    DecoratedText dt = this.getCandidateRow((ICitizen)player);
                    this.box.getChildren().add(2, (Object)dt);
                    noButton.toggledProperty().setValue(Boolean.valueOf(false));
                }
            }
            catch (RuntimeException e) {
                this.logger.error("Failed to accept info", (Throwable)e);
            }
        });
        noButton.setOnAction(mouseEvent -> {
            try {
                if (candidates.contains(player)) {
                    yesButton.getStyleClass().remove((Object)"active");
                    yesButton.getStyleClass().add((Object)"inactive");
                    noButton.getStyleClass().add((Object)"inactive");
                    candidates.remove(player);
                    this.box.getChildren().remove(2);
                    yesButton.toggledProperty().setValue(Boolean.valueOf(false));
                }
            }
            catch (RuntimeException e) {
                this.logger.error("Failed to say no to info", (Throwable)e);
            }
        });
        PlaceHolder ph = new PlaceHolder(30.0, 1.0);
        row.getChildren().addAll((Object[])new Node[]{question, ph, yesButton, noButton});
        this.box.getChildren().add((Object)row);
        this.getContent().addAll((Object[])new Node[]{this.box});
    }

    private boolean canBeCandidate(IPlayer player, ICity town) {
        ICity hometown;
        ESocialRank rank = player.getRank();
        return (rank == ESocialRank.COUNCILMAN || rank == ESocialRank.PATRICIAN || rank == ESocialRank.MAYOR || rank == ESocialRank.ALDERMAN) && town.equals(hometown = player.getHometown());
    }

    private EventHandler<MouseEvent> getAction(VBox box, OpenPatricianLargeWaxButton action) {
        return mouseEvent -> {
            try {
                box.getChildren().clear();
                action.setVisible(false);
                String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TownInfoNotice.petitionIntro", new Object[0], this.locale.getCurrentLocal());
                DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
                box.getChildren().add((Object)text);
                VBox innerBox = new VBox();
                innerBox.setAlignment(Pos.TOP_CENTER);
                StackPane pane = new StackPane(new Node[]{innerBox});
                pane.prefHeightProperty().bind((ObservableValue)text.wrappingWidthProperty());
                template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TownInfoNotice.petitionCityHall", new Object[0], this.locale.getCurrentLocal());
                Label label = this.textFactory.createLabel(template);
                label.setAlignment(Pos.CENTER);
                if (this.canEnlargeCityWalls()) {
                    template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TownInfoNotice.confirm", new Object[0], this.locale.getCurrentLocal());
                    action.setText(template);
                    label.setOnMouseReleased(evt -> {
                        if (this.selectionBox != null) {
                            innerBox.getChildren().remove((Object)this.selectionBox);
                            this.selectionBox = null;
                        }
                        action.setOnAction(event -> {
                            try {
                                CityWallPetition petition = new CityWallPetition();
                                this.cityHallAccessor.getCityHall(this.city.getCity()).setPetition(Optional.of(petition));
                                this.executeOnCloseButtonClicked();
                            }
                            catch (RuntimeException e) {
                                this.logger.error("Failed to accept info message", (Throwable)e);
                            }
                        });
                        action.setVisible(true);
                    });
                } else {
                    label.getStyleClass().add((Object)"inactive");
                }
                innerBox.getChildren().add((Object)label);
                template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TownInfoNotice.petitionGuard", new Object[0], this.locale.getCurrentLocal());
                label = this.textFactory.createLabel(template);
                label.setAlignment(Pos.CENTER);
                if (this.canHaveMoreGuards()) {
                    template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TownInfoNotice.confirm", new Object[0], this.locale.getCurrentLocal());
                    action.setText(template);
                    label.setOnMouseReleased(evt -> {
                        if (this.selectionBox != null) {
                            innerBox.getChildren().remove((Object)this.selectionBox);
                            this.selectionBox = null;
                        }
                        action.setOnAction(event -> {
                            try {
                                MilitiaPetition petition = new MilitiaPetition();
                                this.cityHallAccessor.getCityHall(this.city.getCity()).setPetition(Optional.of(petition));
                                this.executeOnCloseButtonClicked();
                            }
                            catch (RuntimeException e) {
                                this.logger.error("Failed to dismiss info message", (Throwable)e);
                            }
                        });
                        action.setVisible(true);
                    });
                } else {
                    label.getStyleClass().add((Object)"inactive");
                }
                innerBox.getChildren().add((Object)label);
                template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TownInfoNotice.petitionHeadTax", new Object[0], this.locale.getCurrentLocal());
                label = this.textFactory.createLabel(template);
                label.setAlignment(Pos.CENTER);
                label.setOnMouseReleased(evt -> {
                    if (this.selectionBox != null) {
                        innerBox.getChildren().remove((Object)this.selectionBox);
                        this.selectionBox = null;
                    }
                    action.setVisible(true);
                    Label lbl = new Label(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TownInfoNotice.headTax", new Object[0], this.locale.getCurrentLocal()));
                    Image img = this.imageLoader.getImage("icons/minusIcon");
                    ImageView imgView = new ImageView(img);
                    imgView.setId("minusIcon");
                    Label input = new Label();
                    input.setId("headTaxLabel");
                    input.setText(String.valueOf(this.cityHallAccessor.getCityHall(this.city.getCity()).getTreasury().getCurrentHeadTaxValue()));
                    imgView.setOnMouseReleased(e -> {
                        double value = Double.parseDouble(input.getText());
                        input.setText(String.valueOf(Math.max(value - 0.5, 0.0)));
                    });
                    this.selectionBox = new HBox(5.0);
                    this.selectionBox.setAlignment(Pos.TOP_CENTER);
                    this.selectionBox.getChildren().addAll((Object[])new Node[]{lbl, imgView, input});
                    lbl = new Label("%");
                    img = this.imageLoader.getImage("icons/plusIcon");
                    imgView = new ImageView(img);
                    imgView.setId("plusIcon");
                    imgView.setOnMouseReleased(e -> {
                        double value = Double.parseDouble(input.getText());
                        input.setText(String.valueOf(value + 0.5));
                    });
                    this.selectionBox.getChildren().addAll((Object[])new Node[]{lbl, imgView});
                    innerBox.getChildren().add((Object)this.selectionBox);
                    action.setOnAction(e -> {
                        HeadTaxPetition petition = new HeadTaxPetition(Double.parseDouble(input.getText()));
                        this.cityHallAccessor.getCityHall(this.city.getCity()).setPetition(Optional.of(petition));
                        this.executeOnCloseButtonClicked();
                    });
                });
                innerBox.getChildren().add((Object)label);
                template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TownInfoNotice.petitionSpecialTax", new Object[0], this.locale.getCurrentLocal());
                label = this.textFactory.createLabel(template);
                label.setAlignment(Pos.CENTER);
                label.setOnMouseReleased(evt -> {
                    if (this.selectionBox != null) {
                        innerBox.getChildren().remove((Object)this.selectionBox);
                        this.selectionBox = null;
                    }
                    action.setVisible(true);
                    Label lbl = new Label(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TownInfoNotice.specialTax", new Object[0], this.locale.getCurrentLocal()));
                    Image img = this.imageLoader.getImage("icons/minusIcon");
                    ImageView imgView = new ImageView(img);
                    imgView.setId("minusIcon");
                    Label input = new Label();
                    input.setId("specialTaxLabel");
                    input.setText("0");
                    imgView.setOnMouseReleased(e -> {
                        int value = Integer.parseInt(input.getText());
                        input.setText(String.valueOf(Math.max(value - 5000, 0)));
                    });
                    this.selectionBox = new HBox(5.0);
                    this.selectionBox.setAlignment(Pos.TOP_CENTER);
                    this.selectionBox.getChildren().addAll((Object[])new Node[]{lbl, imgView, input});
                    img = this.imageLoader.getImage("icons/coin_icon", 32.0, 32.0);
                    imgView = new ImageView(img);
                    this.selectionBox.getChildren().add((Object)imgView);
                    img = this.imageLoader.getImage("icons/plusIcon");
                    imgView = new ImageView(img);
                    imgView.setId("plusIcon");
                    imgView.setOnMouseReleased(e -> {
                        int value = Integer.parseInt(input.getText());
                        input.setText(String.valueOf(value + 5000));
                    });
                    this.selectionBox.getChildren().addAll((Object[])new Node[]{imgView});
                    innerBox.getChildren().add((Object)this.selectionBox);
                    action.setOnAction(e -> {
                        SpecialTaxPetition petition = new SpecialTaxPetition(Integer.parseInt(input.getText()));
                        this.cityHallAccessor.getCityHall(this.city.getCity()).setPetition(Optional.of(petition));
                        this.executeOnCloseButtonClicked();
                    });
                });
                innerBox.getChildren().add((Object)label);
                box.getChildren().add((Object)pane);
            }
            catch (RuntimeException e) {
                this.logger.error("Failed to switch outrigger", (Throwable)e);
            }
        };
    }

    private boolean canEnlargeCityWalls() {
        return this.city.getCity().getCityState().getCityWall().getExtension() != ECityWall.EXTENDED_TWICE;
    }

    private boolean canHaveMoreGuards() {
        int maxPossible = this.cityService.getMaxNumberOfGuards(this.city.getCity().getPopulationBinding().get());
        return this.cityHallAccessor.getCityHall(this.city.getCity()).getCityGuard().size() < maxPossible;
    }

    private boolean canPosePetition(ICity town, IPlayer player) {
        ICity hometown;
        ESocialRank rank = player.getRank();
        if (this.cityHallAccessor.getCityHall(town).getPetition().isPresent()) {
            return false;
        }
        if ((rank == ESocialRank.COUNCILMAN || rank == ESocialRank.PATRICIAN || rank == ESocialRank.MAYOR) && town.equals(hometown = player.getHometown())) {
            return true;
        }
        return rank == ESocialRank.ALDERMAN;
    }

    private DecoratedText getCandidateRow(ICitizen candidate) {
        Object[] args;
        if (candidate instanceof IHumanPlayer) {
            IPlayer p = (IPlayer)candidate;
            args = new Object[]{this.modelTranslator.getLocalDisplayDistinctArticle(p.getPersonalData().isMale(), true), this.modelTranslator.getLocalDisplayName(p.getCareerLevel()), this.modelTranslator.getLocalDisplayName(p.getRank()), p.getName() + " " + p.getLastName()};
        } else {
            args = new Object[]{this.modelTranslator.getLocalDisplayDistinctArticle(true, true), this.modelTranslator.getLocalDisplayName((ICareer)EEconomicCareer.SMART), this.modelTranslator.getLocalDisplayName(candidate.getRank()), candidate.getName() + " " + candidate.getLastName()};
        }
        String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TownInfoNotice.candidate", args, this.locale.getCurrentLocal());
        DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
        return text;
    }

    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_CITY_HALL_TREASURY);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
        this.clientServerEventBus.unregister((Object)this);
    }

    @Subscribe
    public void checkDayChangeUpdates(ClockTickDayChange dayChange) {
        ICity town = this.city.getCity();
        IHumanPlayer player = this.city.getPlayer();
        ICityHall cityHall = this.cityHallAccessor.getCityHall(town);
        LocalDateTime electionDate = cityHall.getElectionDate();
        if (this.dateService.isSameDay(electionDate, this.date.getCurrentDate())) {
            Platform.runLater(() -> this.lambda$checkDayChangeUpdates$15(town, (IPlayer)player));
        }
    }

    @Subscribe
    public void checkPostDayChangeUpdates(ElectionWinnerNotification electionResult) {
        if (this.displayAtElectionDay && electionResult.getElectionType().equals((Object)EElectionType.MAYORAL) && electionResult.getCity().equals(this.city.getCity())) {
            ICity town = this.city.getCity();
            IHumanPlayer player = this.city.getPlayer();
            ICityHall cityHall = this.cityHallAccessor.getCityHall(town);
            LocalDateTime electionDate = cityHall.getElectionDate();
            if (!this.dateService.isSameDay(electionDate, this.date.getCurrentDate())) {
                Platform.runLater(() -> this.lambda$checkPostDayChangeUpdates$16(town, (IPlayer)player));
            }
        }
    }

    private /* synthetic */ void lambda$checkPostDayChangeUpdates$16(ICity town, IPlayer player) {
        this.resetContent(town, player);
    }

    private /* synthetic */ void lambda$checkDayChangeUpdates$15(ICity town, IPlayer player) {
        this.resetContent(town, player);
    }
}

