/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.cityhall;

import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.graphic.image.impl.SelectiveCachableXMLImageLoader;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.MapService;
import ch.sahits.game.openpatrician.clientserverinterface.service.ModelStateAccessor;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.IViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.javafx.control.CoinPriceAlwaysVisible;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.control.MoneyTransfer;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.javafx.model.ControlTableCell;
import ch.sahits.game.openpatrician.javafx.model.ITableCell;
import ch.sahits.game.openpatrician.javafx.model.StaticTextTableCell;
import ch.sahits.game.openpatrician.javafx.model.Table;
import ch.sahits.game.openpatrician.javafx.model.TableHeader;
import ch.sahits.game.openpatrician.javafx.model.TableRow;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.javafx.service.JavaFXUtils;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityHall;
import ch.sahits.game.openpatrician.model.city.cityhall.ITreasury;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.Treasury;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import java.time.LocalDateTime;
import java.util.HashMap;
import javafx.beans.Observable;
import javafx.beans.binding.LongBinding;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TreasuryDialog
extends CloseButtonDialog {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private ModelStateAccessor cityHallAccessor;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private ModelTranslations modelTranslator;
    @Autowired
    private Date date;
    @Autowired
    private MapService cityService;
    @Autowired
    private JavaFXUtils fxUtils;
    @Autowired
    @Qualifier(value="xmlImageLoader")
    private SelectiveCachableXMLImageLoader imageLoader;
    private final ICityPlayerProxyJFX city;
    private HBox selectionBox = null;
    private GridPane grid;

    public TreasuryDialog(ICityPlayerProxyJFX city) {
        this.city = city;
        this.getStylesheets().add((Object)this.getClass().getResource("/styles/base.css").toExternalForm());
        this.getStyleClass().add((Object)"dialog");
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog.title", new Object[0], this.locale.getCurrentLocal()));
        LocalDateTime now = this.date.getCurrentDate();
        LocalDateTime firstOfMont = now.minusDays(now.getDayOfMonth() - 1);
        Object[] args = new Object[]{this.modelTranslator.toShortDate(firstOfMont)};
        String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog.subtitle", args, this.locale.getCurrentLocal());
        DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
        text.setLayoutX(30.0);
        this.getContent().add((Object)text);
        ICityHall cityHall = this.cityHallAccessor.getCityHall(this.city.getCity());
        final ITreasury treasury = cityHall.getTreasury();
        LongBinding total = new LongBinding(){
            {
                super.bind(new Observable[]{treasury.paidTaxesProperty(), treasury.paidSpecialTaxesProperty(), treasury.donationsProperty(), treasury.cityGuardCostsProperty(), treasury.buildingCostsProperty(), treasury.outriggerCostsProperty(), treasury.siegeCostsProperty(), treasury.otherCostsProperty(), treasury.otherIncomeProperty()});
            }

            protected long computeValue() {
                return 0L + treasury.getPaidTaxes() + treasury.getPaidSpecialTaxes() + (long)treasury.getDonations() - (long)treasury.getCityGuardCosts() - (long)treasury.getBuildingCosts() - (long)treasury.getOutriggerCosts() - (long)treasury.getSiegeCosts() - (long)treasury.getOtherCosts() + (long)treasury.getOtherIncome();
            }
        };
        Table tableModel = new Table();
        TableHeader header = new TableHeader(2);
        header.add((ITableCell)new StaticTextTableCell(""));
        header.add((ITableCell)new StaticTextTableCell(""));
        tableModel.setHeader(header);
        tableModel.setColumnWidth(new Integer[]{300, 100});
        tableModel.setAligenment(0, HPos.LEFT);
        tableModel.setAligenment(1, HPos.RIGHT);
        TableRow row = new TableRow();
        template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog.headAndPropertyTax", new Object[0], this.locale.getCurrentLocal());
        row.add((ITableCell)new StaticTextTableCell(template));
        CoinPriceAlwaysVisible control = new CoinPriceAlwaysVisible();
        control.amountProperty().bind((ObservableValue)treasury.paidTaxesProperty().asString());
        row.add((ITableCell)new ControlTableCell((Node)control));
        tableModel.add(row);
        row = new TableRow();
        template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog.specialTaxes", new Object[0], this.locale.getCurrentLocal());
        row.add((ITableCell)new StaticTextTableCell(template));
        control = new CoinPriceAlwaysVisible();
        control.amountProperty().bind((ObservableValue)treasury.paidSpecialTaxesProperty().asString());
        row.add((ITableCell)new ControlTableCell((Node)control));
        tableModel.add(row);
        row = new TableRow();
        template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog.donation", new Object[0], this.locale.getCurrentLocal());
        row.add((ITableCell)new StaticTextTableCell(template));
        control = new CoinPriceAlwaysVisible();
        control.amountProperty().bind((ObservableValue)treasury.donationsProperty().asString());
        row.add((ITableCell)new ControlTableCell((Node)control));
        tableModel.add(row);
        row = new TableRow();
        template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog.donation.guardsCost", new Object[0], this.locale.getCurrentLocal());
        row.add((ITableCell)new StaticTextTableCell(template));
        control = new CoinPriceAlwaysVisible();
        control.amountProperty().bind((ObservableValue)treasury.cityGuardCostsProperty().asString());
        row.add((ITableCell)new ControlTableCell((Node)control));
        tableModel.add(row);
        row = new TableRow();
        template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog.buildCosts", new Object[0], this.locale.getCurrentLocal());
        row.add((ITableCell)new StaticTextTableCell(template));
        control = new CoinPriceAlwaysVisible();
        control.amountProperty().bind((ObservableValue)treasury.buildingCostsProperty().asString());
        row.add((ITableCell)new ControlTableCell((Node)control));
        tableModel.add(row);
        row = new TableRow();
        template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog.outriggerCosts", new Object[0], this.locale.getCurrentLocal());
        row.add((ITableCell)new StaticTextTableCell(template));
        control = new CoinPriceAlwaysVisible();
        control.amountProperty().bind((ObservableValue)treasury.outriggerCostsProperty().asString());
        row.add((ITableCell)new ControlTableCell((Node)control));
        tableModel.add(row);
        row = new TableRow();
        template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog.siege", new Object[0], this.locale.getCurrentLocal());
        row.add((ITableCell)new StaticTextTableCell(template));
        control = new CoinPriceAlwaysVisible();
        control.amountProperty().bind((ObservableValue)treasury.siegeCostsProperty().asString());
        row.add((ITableCell)new ControlTableCell((Node)control));
        tableModel.add(row);
        row = new TableRow();
        template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog.otherCosts", new Object[0], this.locale.getCurrentLocal());
        row.add((ITableCell)new StaticTextTableCell(template));
        control = new CoinPriceAlwaysVisible();
        control.amountProperty().bind((ObservableValue)treasury.otherCostsProperty().add((ObservableNumberValue)treasury.otherIncomeProperty()).asString());
        row.add((ITableCell)new ControlTableCell((Node)control));
        tableModel.add(row);
        row = new TableRow();
        tableModel.add(row);
        row = new TableRow();
        template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog.total", new Object[0], this.locale.getCurrentLocal());
        row.add((ITableCell)new StaticTextTableCell(template));
        control = new CoinPriceAlwaysVisible();
        control.amountProperty().bind((ObservableValue)total.asString());
        row.add((ITableCell)new ControlTableCell((Node)control));
        tableModel.add(row);
        row = new TableRow();
        tableModel.add(row);
        row = new TableRow();
        template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog.available", new Object[0], this.locale.getCurrentLocal());
        row.add((ITableCell)new StaticTextTableCell(template));
        control = new CoinPriceAlwaysVisible();
        control.amountProperty().bind((ObservableValue)treasury.cashProperty().asString());
        row.add((ITableCell)new ControlTableCell((Node)control));
        tableModel.add(row);
        row = new TableRow();
        tableModel.add(row);
        row = new TableRow();
        tableModel.add(row);
        row = new TableRow();
        tableModel.add(row);
        template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog.donate", new Object[0], this.locale.getCurrentLocal());
        OpenPatricianLargeWaxButton donate = new OpenPatricianLargeWaxButton(template);
        donate.getStyleClass().add((Object)"actionButton");
        donate.setId("donate");
        template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog.withdraw", new Object[0], this.locale.getCurrentLocal());
        OpenPatricianLargeWaxButton withdraw = new OpenPatricianLargeWaxButton(template);
        withdraw.getStyleClass().add((Object)"actionButton");
        if (!this.city.getPlayer().getRank().equals((Object)ESocialRank.MAYOR) || !this.city.getPlayer().getHometown().equals(this.city.getCity())) {
            withdraw.setVisible(false);
        }
        withdraw.setId("withdraw");
        donate.setOnAction(this.getDonateAction(donate, withdraw));
        withdraw.setOnAction(this.getWithdrawalAction(donate, withdraw));
        row = new TableRow();
        row.add((ITableCell)new ControlTableCell((Node)donate));
        row.add((ITableCell)new ControlTableCell((Node)withdraw));
        tableModel.add(row);
        this.grid = this.fxUtils.createGridPaneFromModel(tableModel);
        this.grid.getStyleClass().add((Object)"tableFont");
        this.grid.setLayoutX(50.0);
        this.grid.setLayoutY(127.0);
        this.getContent().add((Object)this.grid);
    }

    private EventHandler<MouseEvent> getWithdrawalAction(OpenPatricianLargeWaxButton donation, OpenPatricianLargeWaxButton withdraw) {
        return mouseEvent -> {
            try {
                this.grid.getChildren().removeAll((Object[])new Node[]{donation, withdraw});
                Treasury treasury = (Treasury)this.cityHallAccessor.getCityHall(this.city.getCity()).getTreasury();
                MoneyTransfer moneyTransfer = this.fxUtils.getMoneyTransfer((IDataImageLoader)this.imageLoader);
                moneyTransfer.setStepSize(100);
                moneyTransfer.maxTransfereableProperty().bind((ObservableValue)treasury.cashProperty());
                moneyTransfer.setAmount(0);
                this.selectionBox = new HBox(5.0);
                String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog.withdraw", new Object[0], this.locale.getCurrentLocal());
                OpenPatricianLargeWaxButton action = new OpenPatricianLargeWaxButton(template);
                action.getStyleClass().add((Object)"actionButton");
                action.setId("withdrawlButton");
                this.selectionBox.getChildren().addAll((Object[])new Node[]{moneyTransfer, action});
                this.selectionBox.setLayoutX(100.0);
                this.selectionBox.setLayoutY(577.0);
                this.getContent().add((Object)this.selectionBox);
                action.setOnAction(evt -> {
                    try {
                        int withdrawl = moneyTransfer.getAmount();
                        treasury.subtractOtherCosts(withdrawl);
                        this.city.getPlayer().getCompany().updateCash((long)withdrawl);
                        this.executeOnCloseButtonClicked();
                    }
                    catch (RuntimeException e) {
                        this.logger.error("Failed to withdraw cash", (Throwable)e);
                    }
                });
            }
            catch (RuntimeException e) {
                this.logger.error("Failed to withdraw from the city", (Throwable)e);
            }
        };
    }

    private EventHandler<MouseEvent> getDonateAction(OpenPatricianLargeWaxButton donation, OpenPatricianLargeWaxButton withdraw) {
        return mouseEvent -> {
            try {
                this.grid.getChildren().removeAll((Object[])new Node[]{donation, withdraw});
                ICompany company = this.city.getPlayer().getCompany();
                MoneyTransfer moneyTransfer = this.fxUtils.getMoneyTransfer((IDataImageLoader)this.imageLoader);
                moneyTransfer.setStepSize(100);
                moneyTransfer.maxTransfereableProperty().bind((ObservableValue)company.cashProperty());
                moneyTransfer.setAmount(0);
                this.selectionBox = new HBox(5.0);
                String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog.donate", new Object[0], this.locale.getCurrentLocal());
                OpenPatricianLargeWaxButton action = new OpenPatricianLargeWaxButton(template);
                action.getStyleClass().add((Object)"actionButton");
                action.setId("donateButton");
                this.selectionBox.getChildren().addAll((Object[])new Node[]{moneyTransfer, action});
                this.selectionBox.setLayoutX(100.0);
                this.selectionBox.setLayoutY(577.0);
                this.getContent().add((Object)this.selectionBox);
                action.setOnAction(e -> {
                    Treasury treasury = (Treasury)this.cityHallAccessor.getCityHall(this.city.getCity()).getTreasury();
                    int donations = moneyTransfer.getAmount();
                    treasury.addDonations(donations);
                    company.updateCash((long)(-donations));
                    this.executeOnCloseButtonClicked();
                });
            }
            catch (RuntimeException e2) {
                this.logger.error("Failed to donate to the city", (Throwable)e2);
            }
        };
    }

    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_CITY_HALL_TREASURY);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }
}

