/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.events;

import ch.sahits.game.openpatrician.clientserverinterface.model.event.ChildBirthState;
import ch.sahits.game.openpatrician.display.dialog.DefaultSimpleDialog;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import javafx.geometry.Pos;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN})
public class ChildBirthDialog
extends DefaultSimpleDialog {
    @Autowired
    private ModelTranslations modelTranslations;
    private ChildBirthState state;

    public ChildBirthDialog(ChildBirthState state) {
        super(true);
        this.state = state;
    }

    @PostConstruct
    private void initializeDialog() {
        String letterDate = this.modelTranslations.toDisplayString(this.state.getDate());
        this.addDecoratedText("letter.location.date", "dateLocation", Pos.CENTER_RIGHT, new Object[]{this.state.getLocation(), letterDate});
        this.addVerticalSpacer(20);
        this.addDecoratedText("letter.dairy.entry", "diryEntry", new Object[0]);
        this.addVerticalSpacer(20);
        if (this.state.isMale()) {
            this.addDecoratedText("ch.sahits.game.openpatrician.display.dialog.event.ChildBirthDialog.maleChild", "maleChild", this.state.getName());
        } else {
            this.addDecoratedText("ch.sahits.game.openpatrician.display.dialog.event.ChildBirthDialog.femaleChild", "femaleChild", this.state.getName());
        }
        if (this.state.isWifeDeath()) {
            this.addDecoratedText("ch.sahits.game.openpatrician.display.dialog.event.ChildBirthDialog.wifeDeath", "wifeDeath", new Object[0]);
        }
    }
}

