/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.event.handler.impl;

import ch.sahits.game.openpatrician.clientserverinterface.service.ClientServerFactory;
import ch.sahits.game.openpatrician.clientserverinterface.service.DialogTemplateFactory;
import ch.sahits.game.openpatrician.clientserverinterface.service.DialogTemplateParameterSupplier;
import ch.sahits.game.openpatrician.clientserverinterface.service.EDialogTemplateType;
import ch.sahits.game.openpatrician.display.event.data.CourierPatrolStateInternal;
import ch.sahits.game.openpatrician.display.event.task.ClientTaskFactory;
import ch.sahits.game.openpatrician.event.data.ShipEntersPortEvent;
import ch.sahits.game.openpatrician.event.handler.ShipEntersPortEventListener;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DisplayTemplateMessage;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ui.DialogTemplate;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.Random;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class NextCourierPatrolStation
extends ShipEntersPortEventListener {
    private final CourierPatrolStateInternal state;
    private final IPlayer player;
    private final LocalDateTime deadline;
    @Autowired
    private Date date;
    @Autowired
    @XStreamOmitField
    private ClientTaskFactory taskFactory;
    @Autowired
    private Random rnd;
    @Autowired
    @Qualifier(value="clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;
    @Autowired
    @XStreamOmitField
    private ClientServerFactory clientServerFactory;
    @Autowired
    @XStreamOmitField
    private DialogTemplateFactory dialogTemplateFactory;
    @Autowired
    @XStreamOmitField
    private Locale locale;
    @Autowired
    @XStreamOmitField
    private MessageSource messageSource;

    public NextCourierPatrolStation(IShip ship, ICity city, CourierPatrolStateInternal state, IPlayer player, LocalDateTime deadline) {
        super((INavigableVessel)ship, city);
        this.state = state;
        this.player = player;
        this.deadline = deadline;
        state.removeFirstCity();
    }

    @PostConstruct
    private void initializeEventBus() {
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregisterEventBus() {
        this.clientServerEventBus.unregister((Object)this);
    }

    public void handleShipEntersPort(ShipEntersPortEvent event) {
        super.handleShipEntersPort(event);
        LocalDateTime now = this.date.getCurrentDate();
        if (now.isAfter(this.deadline)) {
            if (this.player instanceof IHumanPlayer) {
                DialogTemplateParameterSupplier parameterSupplier = new DialogTemplateParameterSupplier(new Object[]{this.getShip().getName(), event.getCity().getName(), this.clientServerFactory.dateSupplier()});
                DialogTemplate template = this.dialogTemplateFactory.createDialogTemplate(EDialogTemplateType.COURIER_SERVICE_FINISHED_UNSUCCESSFUL, parameterSupplier);
                DisplayTemplateMessage message = new DisplayTemplateMessage("ch.sahits.game.event.handler.impl.NextCourierPatrolStation.unreliable", template, new Object[0]);
                TargetedEvent tagetDisplayMsg = new TargetedEvent((IHumanPlayer)this.player, (Object)message);
                this.clientServerEventBus.post((Object)tagetDisplayMsg);
            }
            ((IShip)this.getShip()).leavePassenger();
            this.clientServerEventBus.unregister((Object)this);
        }
    }

    public boolean execute(ICity city) {
        Optional<ICity> nextCity = this.state.nextDestination();
        if (!nextCity.isPresent()) {
            int premium = this.state.getPremium();
            if (this.player instanceof IHumanPlayer) {
                this.player.getCompany().updateCash((long)premium);
            } else {
                this.player.getCompany().updateCashDirectly((long)premium);
            }
            ((IShip)this.getShip()).leavePassenger();
            if (this.player instanceof IHumanPlayer) {
                DialogTemplateParameterSupplier parameterSupplier = new DialogTemplateParameterSupplier(new Object[]{this.getShip().getName(), city.getName(), this.clientServerFactory.dateSupplier(), premium});
                DialogTemplate template = this.dialogTemplateFactory.createDialogTemplate(EDialogTemplateType.COURIER_SERVICE_FINISHED_SUCCESSFUL, parameterSupplier);
                DisplayTemplateMessage message = new DisplayTemplateMessage("ch.sahits.game.event.handler.impl.NextCourierPatrolStation.salary", template, new Object[]{premium});
                TargetedEvent tagetDisplayMsg = new TargetedEvent((IHumanPlayer)this.player, (Object)message);
                this.clientServerEventBus.post((Object)tagetDisplayMsg);
            }
            this.unregisterEventBus();
        } else {
            ICity next = nextCity.get();
            this.state.removeFirstCity();
            int minutes = this.rnd.nextInt(600);
            LocalDateTime postMessage = this.date.getCurrentDate().plusMinutes(minutes);
            this.taskFactory.getPostponedDisplayMessage(postMessage, "ch.sahits.game.event.handler.impl.NextCourierPatrolStation.nextStation", next.getName());
            LocalDateTime deadline = this.date.getCurrentDate().plusDays(6L);
            new NextCourierPatrolStation((IShip)this.getShip(), this.state.nextDestination().get(), this.state, this.player, deadline);
        }
        return true;
    }
}

