/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.event.handler.impl;

import ch.sahits.game.openpatrician.display.event.data.PatrolInternalState;
import ch.sahits.game.openpatrician.display.event.handler.impl.AttackListener;
import ch.sahits.game.openpatrician.display.event.task.ClientTaskFactory;
import ch.sahits.game.openpatrician.event.data.ShipEntersPortEvent;
import ch.sahits.game.openpatrician.event.handler.ShipEntersPortEventListener;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.Random;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
class NextPatrolStation
extends ShipEntersPortEventListener {
    private final PatrolInternalState state;
    private final IPlayer player;
    private final LocalDateTime deadline;
    private final AttackListener atackListener;
    @Autowired
    private Date date;
    @Autowired
    @XStreamOmitField
    private Random rnd;
    @Autowired
    @Qualifier(value="clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;
    @Autowired
    @XStreamOmitField
    private ClientTaskFactory taskFactory;
    @Autowired
    @XStreamOmitField
    private Locale locale;
    @Autowired
    @XStreamOmitField
    private MessageSource messageSource;

    public NextPatrolStation(IShip ship, ICity city, PatrolInternalState state, IPlayer player, LocalDateTime deadline, AttackListener atackListener) {
        super((INavigableVessel)ship, city);
        this.state = state;
        this.player = player;
        this.deadline = deadline;
        this.atackListener = atackListener;
        state.removeFirstCity();
    }

    @PostConstruct
    private void initEventBus() {
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregisterEventBus() {
        this.clientServerEventBus.unregister((Object)this);
    }

    public void handleShipEntersPort(ShipEntersPortEvent event) {
        super.handleShipEntersPort(event);
        LocalDateTime now = this.date.getCurrentDate();
        if (now.isAfter(this.deadline)) {
            this.clientEventBus.post((Object)new DisplayMessage("ch.sahits.game.event.handler.impl.NextCourierPatrolStation.unreliable", new Object[0]));
            this.clientServerEventBus.unregister((Object)this);
            this.clientServerEventBus.unregister((Object)this.atackListener);
        }
    }

    public boolean execute(ICity city) {
        Optional<ICity> nextCity = this.state.nextDestination();
        if (!nextCity.isPresent()) {
            int premium = this.state.getPremium() + this.state.getNumberOfAttacks() * this.state.getBonusPerAttack();
            if (this.player instanceof IHumanPlayer) {
                this.player.getCompany().updateCash((long)premium);
            } else {
                this.player.getCompany().updateCashDirectly((long)premium);
            }
            this.clientEventBus.post((Object)new DisplayMessage("ch.sahits.game.event.handler.impl.NextPatrolStation.premium", new Object[]{premium}));
            this.clientServerEventBus.unregister((Object)this.atackListener);
            this.unregisterEventBus();
            this.clientServerEventBus.unregister((Object)this.atackListener);
        } else {
            ICity next = nextCity.get();
            this.state.removeFirstCity();
            int minutes = this.rnd.nextInt(600);
            LocalDateTime postMessage = this.date.getCurrentDate().plusMinutes(minutes);
            this.taskFactory.getPostponedDisplayMessage(postMessage, "ch.sahits.game.event.handler.impl.NextCourierPatrolStation.nextStation", next.getName());
            LocalDateTime deadline = this.date.getCurrentDate().plusDays(6L);
            new NextPatrolStation((IShip)this.getShip(), this.state.nextDestination().get(), this.state, this.player, deadline, this.atackListener);
        }
        return true;
    }
}

