/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.gameplay.impl;

import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.gameplay.impl.ScenePolygonInitialzer;
import ch.sahits.game.openpatrician.display.javafx.MainGameView;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.IViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.google.common.eventbus.AsyncEventBus;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class LoanerScenePolygonInitializer
extends ScenePolygonInitialzer {
    @Autowired
    private ClientViewState viewState;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;

    public LoanerScenePolygonInitializer() {
        super("images/scene/loaner");
    }

    @Override
    protected EventHandler<MouseEvent> createEventHandler(String name) {
        switch (name) {
            case "exit": {
                try {
                    return arg0 -> {
                        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.MAIN_VIEW_PORT);
                        this.clientEventBus.post((Object)new ViewChangeEvent(MainGameView.class, (Object)proxy));
                        proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_HIDE);
                        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
                    };
                }
                catch (RuntimeException e) {
                    logger.error("Failed to switch back port", (Throwable)e);
                }
            }
        }
        throw new IllegalStateException("Unhandled polygon action: " + name);
    }
}

