/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.gameplay.impl;

import ch.sahits.game.openpatrician.display.gameplay.impl.ArmoryPolygonInitializer;
import ch.sahits.game.openpatrician.display.gameplay.impl.ChurchScenePolygonInitializer;
import ch.sahits.game.openpatrician.display.gameplay.impl.CityHallScenePolygonInitializer;
import ch.sahits.game.openpatrician.display.gameplay.impl.EScene;
import ch.sahits.game.openpatrician.display.gameplay.impl.GuildScenePolygonInitializer;
import ch.sahits.game.openpatrician.display.gameplay.impl.LoanerScenePolygonInitializer;
import ch.sahits.game.openpatrician.display.gameplay.impl.MarketScenePolygonInitializer;
import ch.sahits.game.openpatrician.display.gameplay.impl.PortScenePolygonInitializer;
import ch.sahits.game.openpatrician.display.gameplay.impl.ScenePolygonInitialzer;
import ch.sahits.game.openpatrician.display.gameplay.impl.ShipyardScenePolygonInitializer;
import ch.sahits.game.openpatrician.display.gameplay.impl.TavernScenePolygonInitializer;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ObjectPropertyType;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class PolygonInitializerFactory {
    @ObjectPropertyType(value=EScene.class)
    private ObjectProperty<EScene> currentScene = new SimpleObjectProperty((Object)this, "currentScene", (Object)EScene.PORT);
    @Autowired
    private PortScenePolygonInitializer portSceneInitializer;
    @Autowired
    private MarketScenePolygonInitializer marketSceneInitializer;
    @Autowired
    private ShipyardScenePolygonInitializer shipyardSceneInitializer;
    @Autowired
    private TavernScenePolygonInitializer tavernSceneInitializer;
    @Autowired
    private CityHallScenePolygonInitializer cityHallSceneInitializer;
    @Autowired
    private LoanerScenePolygonInitializer loanerSceneInitializer;
    @Autowired
    private ChurchScenePolygonInitializer churchSceneInitializer;
    @Autowired
    private GuildScenePolygonInitializer guildSceneInitializer;
    @Autowired
    private ArmoryPolygonInitializer armoryPolygonInitializer;

    public ObjectProperty<EScene> currentSceneProperty() {
        return this.currentScene;
    }

    public ScenePolygonInitialzer getScenePolygonInitializer() {
        switch ((EScene)((Object)this.currentScene.get())) {
            case PORT: {
                return this.portSceneInitializer;
            }
            case MARKET: {
                return this.marketSceneInitializer;
            }
            case SHIPYARD: {
                return this.shipyardSceneInitializer;
            }
            case TAVERN: {
                return this.tavernSceneInitializer;
            }
            case CITY_HALL: {
                return this.cityHallSceneInitializer;
            }
            case LOANER: {
                return this.loanerSceneInitializer;
            }
            case CHURCH: {
                return this.churchSceneInitializer;
            }
            case GUILD: {
                return this.guildSceneInitializer;
            }
            case ARMORY: {
                return this.armoryPolygonInitializer;
            }
        }
        throw new IllegalStateException("Unsupported scene: " + this.currentScene.get());
    }
}

