package ch.sahits.game.openpatrician.display.dialog;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.NoticeBoardClose;
import ch.sahits.game.openpatrician.javafx.control.BarrelIconView;
import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import javafx.beans.binding.StringBinding;
import javafx.scene.Group;
import javafx.scene.image.ImageView;
import javafx.scene.text.Text;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

import java.util.Optional;

/**
 * Dialog for trading between the city and the storage.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Nov 23, 2013
 *
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class CityStorageTradeDialog extends BaseTradeDialog {
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;
	@Autowired
	private Locale locale;

	@Autowired
	private MessageSource messageSource;

	public CityStorageTradeDialog(ICityPlayerProxyJFX city) {
		super(city, EDialogType.PORT_CITY_TO_STORAGE);
	}


	/**
	 * Trade to the ship.
	 * @return localized string for trading destination storage
	 */
	@Override
	protected String getTradeToDestination() {
		return messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.CityStorageTradeDialog.storage", new Object[]{}, locale.getCurrentLocal());
	}
	@Override
	protected Group createSubTitle(final ICityPlayerProxyJFX city) {
		StringBinding cityPopulation = new StringBinding() {
			{
				super.bind(city.getCity().getPopulationBinding());
			}
			
			@Override
			protected String computeValue() {
				ICity actualCity = city.getCity();
				return actualCity.getName()+" "+actualCity.getPopulationBinding().asString().get();
			}
		};
		Text cityText = new Text();
		cityText.textProperty().bind(cityPopulation);
		cityText.getStyleClass().add("dialogText");
		Group g = new Group();
		g.setManaged(false);
		
		final Optional<ITradingOffice> optOffice = city.getPlayer().findTradingOffice(city.getCity());
		ImageView barrel = new BarrelIconView();
		barrel.setLayoutX(200 - 26);
		barrel.setLayoutY(-12);
		
		StringBinding storageLoad = new StringBinding() {
			
			{
				optOffice.ifPresent(iTradingOffice -> {
					ITradingOffice office = iTradingOffice;
					super.bind(office.storedAmountBinding(), office.capacityProperty());
				});
			}
			
			@Override
			protected String computeValue() {
				if (optOffice.isPresent()) {
					ITradingOffice office = optOffice.get();
					return office.storedAmountBinding().asString().get()+" / "+office.capacityProperty().get();
				} else {
					return "0 / 0";
				}
			}
		};
		
		Text shipSpace = new Text();
		shipSpace.textProperty().bind(storageLoad);
		shipSpace.getStyleClass().add("dialogText");
		shipSpace.setLayoutX(200);
		
		Text shipName = new Text(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.CityStorageTradeDialog.storage", new Object[]{}, locale.getCurrentLocal()));
		shipName.getStyleClass().add("dialogText");
		shipName.setLayoutX(300);
		
		g.getChildren().addAll(cityText, barrel, shipSpace, shipName);
		return g;
	}


	@Override
	public void executeOnCloseButtonClicked() {
        clientEventBus.post(new NoticeBoardClose());
		super.executeOnCloseButtonClicked();
	}
	
	

}
