package ch.sahits.game.openpatrician.display.dialog;

import ch.sahits.game.graphic.image.IFontLoader;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.javafx.MainGameView;
import ch.sahits.game.openpatrician.event.NoticeBoardClose;
import ch.sahits.game.openpatrician.javafx.control.PaginationV2;
import ch.sahits.game.openpatrician.javafx.control.PaginationV2Builder;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import ch.sahits.game.openpatrician.utilities.model.Text;
import ch.sahits.game.openpatrician.utilities.service.TextParser;
import javafx.geometry.Insets;
import javafx.scene.text.Font;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

/**
 * Dialog presenting personal data.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Dec 7, 2013
 *
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.SINGLETON_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class HistoryStandaloneDialog extends CloseButtonDialog {
	private final Logger logger = LogManager.getLogger(getClass());

	/** Reference to the city view model */
	protected final ICityPlayerProxyJFX city;
	private final String historyResource;
	@Autowired
	private MessageSource messageSource;
	@Autowired
	private Locale locale;
	@Autowired
	@Qualifier("resourceReference")
	private MessageSource resources;
	@Autowired
	private TextParser textParser;
	@Autowired
	private IFontLoader fontLoader;

	@Autowired
	private ModelTranslations modelTranslator;

	public HistoryStandaloneDialog( ICityPlayerProxyJFX city, String historyResource) {
		super();
		this.city = city;
		this.historyResource = historyResource;
	}
	@PostConstruct
	private void initializeDialog() {
		final Text historyText = getHistoryText();
		Insets insets = new Insets(FRAME_BORDER, FRAME_BORDER, FRAME_BORDER, FRAME_BORDER * 2);
		Font headerFont = fontLoader.createDefaultFont(24); // bold font not available
		Font defaultfont = fontLoader.createDefaultFont(18);
		PaginationV2 pagination = PaginationV2Builder.create()
				.backButtonLabel(messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.CreditsScene.back", new Object[]{}, locale.getCurrentLocal()))
				.nextButtonLabel(messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.CreditsScene.next", new Object[]{}, locale.getCurrentLocal()))
				.text(historyText)
				.contentMaxWidth(WRAPPING_WIDTH)
				.contentMaxHeight(CLOSE_BTN_Y_POS - 4 * FRAME_BORDER)
				.padding(insets)
				.navigationLabelFont(defaultfont)
				.headerFont(headerFont)
				.paragraphFont(defaultfont)
				.centeredFont(defaultfont)
				.firstLastPageAction(event -> {
							MainGameView mainGameView = (MainGameView) getParent();
							mainGameView.closeDialog();
						}
				)
				.build();
		pagination.setLayoutY(FRAME_BORDER * 2);

//		getContent().remove(getCloseButton()); // todo: andi 9/26/15: if the close button is removed or hidden the content no longer renders

		getContent().add(pagination);
	}

	/**
	 * Retrieve the history text.
	 * @return Text component for the localized history text.
	 */
	private Text getHistoryText() {
		String resourceName = resources.getMessage(historyResource, new Object[0], locale.getCurrentLocal());
		URL url = getClass().getClassLoader().getResource(resourceName);
		try {
			InputStream is= url.openStream();
			return textParser.parse(is);
		} catch (IOException e) {
			logger.warn("History text could not be found: " + url.toExternalForm());
			return new Text();
		}
	}

	@Override
	public void executeOnCloseButtonClicked() {
		clientEventBus.post(new NoticeBoardClose());
		super.executeOnCloseButtonClicked();
	}

}
