package ch.sahits.game.openpatrician.display.dialog.tavern;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.ClientServerFactory;
import ch.sahits.game.openpatrician.clientserverinterface.service.DialogTemplateParameterSupplier;
import ch.sahits.game.openpatrician.clientserverinterface.service.EDialogTemplateType;
import ch.sahits.game.openpatrician.clientserverinterface.service.LinearDeadlinePremiumCalculator;
import ch.sahits.game.openpatrician.display.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.dialog.Dialog;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.people.IFugitive;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;
import java.time.LocalDateTime;
import java.util.HashMap;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 28, 2013
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernFugativeDialog extends TavernBaseSideRoomPersonDialog {
    @Autowired
    private EventHandlerFactory eventHandlerFactory;
    @Autowired
    private ClientServerFactory clientServerFactory;


    public TavernFugativeDialog(ICityPlayerProxyJFX city) {
        super(city, city.getCity().getCityState().getTavernState().getFugative());
    }
    @PostConstruct
    private void initializeDialog() {
        setTitle(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernFugitiveDialog.title", new Object[]{}, locale.getCurrentLocal()));
        initializeButtons();
        IFugitive fugitive = (IFugitive) currentPerson.get();
        DecoratedText text = new DecoratedText();
        text.setLayoutX(2 * Dialog.FRAME_BORDER);
        text.setLayoutY(100);
        text.setWrappingWidth(Dialog.WRAPPING_WIDTH);

        String loadedText = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernFugitiveDialog.dialog", new Object[0], locale.getCurrentLocal());

        HashMap<String, Object> parameters = new HashMap<>();
        parameters.put("destination", fugitive.getDestination().getName());
        parameters.put("amount", fugitive.getPremium());
        DecoratedText dt = decoratedTextFactory.createDecoratedText(loadedText, parameters);

        getContent().addAll(dt);
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding() {
            {
                super.bind(city.getPlayersShips());
                if (city.getActiveShip() instanceof IShip) {
                    ((IShip)city.getActiveShip()).passengerPresentProperty();
                }
            }
            @Override
            protected boolean computeValue() {
                return !(city.getActiveShip() instanceof IShip) || city.getPlayersShips().isEmpty() || ((IShip)city.getActiveShip()).passengerPresentProperty().get();
            }
        };
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return mouseEvent -> {
            try {
                IShip ship = null;
                if (city.getActiveShip() instanceof IShip) {
                    ship = (IShip) city.getActiveShip();
                }
                if (ship != null) {
                    IFugitive fugitive = (IFugitive) currentPerson.get();
                    ship.addPassenger(fugitive);
                    final LocalDateTime now = date.getCurrentDate();
                    final LocalDateTime deadline = now.plusWeeks(2);
                    LinearDeadlinePremiumCalculator premiumCalculator = clientServerFactory.premiumCalculator(now, deadline, fugitive.getPremium());
                    DialogTemplateParameterSupplier parameterSupplier = new DialogTemplateParameterSupplier(new Object[]{fugitive.getDestination().getName(), ship.getName(), clientServerFactory.dateSupplier(), premiumCalculator});
                    eventHandlerFactory.getPassengerLeavingOnShipArrivalHandler(ship, fugitive.getDestination(), city.getPlayer(), deadline, EDialogTemplateType.FUGITIVE_LEAVES_SHIP, parameterSupplier,  premiumCalculator);
                    clientEventBus.post(new DisplayMessage("ch.sahits.game.openpatrician.display.dialog.TavernFugitiveDialog.acceptMessage", ship.getName()));
                    fugitive.leave();
                    city.getPlayer().updateCrimialDrive(-1);
                    executeOnCloseButtonClicked();
                }
            } catch (RuntimeException e) {
                logger.error("Failed to accept fugitive offer", e);
            }
        };
    }
}
