package ch.sahits.game.openpatrician.display.dialog.tavern;

import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.display.dialog.service.TavernDialogUtil;
import ch.sahits.game.openpatrician.display.javafx.MainGameView;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.people.IInformant;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;
import java.util.HashMap;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 28, 2013
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernInformantDialogPageOne extends CloseButtonDialog {
    private final Logger logger = LogManager.getLogger(getClass());
    private final ICityPlayerProxyJFX city;
    private final IInformant informant;
    @Autowired
    private TavernDialogUtil tavernDialogUtil;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private Locale locale;

    @Autowired
    private MessageSource messageSource;

    private final TavernState tavernState;

    public TavernInformantDialogPageOne(ICityPlayerProxyJFX city) {
        super();
        this.city = city;
        tavernState = city.getCity().getCityState().getTavernState();
        informant =  tavernState.getInformant();
    }
    @PostConstruct
    private void initializeDialog() {
        setTitle(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernInformantDialogPageOne.title", new Object[]{informant.getName()}, locale.getCurrentLocal()));
        String loadedText = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernInformantDialogPageOne.dialog", new Object[0], locale.getCurrentLocal());

        HashMap<String, Object> parameters = new HashMap<>();
        final int price = informant.getPrice(city.getPlayer());
        parameters.put("price", price);
        DecoratedText dt = decoratedTextFactory.createDecoratedText(loadedText, parameters);


        final OpenPatricianLargeWaxButton acceptButton = new OpenPatricianLargeWaxButton(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernInformantDialogPageOne.buy", new Object[]{}, locale.getCurrentLocal()));
        acceptButton.getStyleClass().add("actionButton");
        int BUTTON_X = (WIDTH - 124) / 2;
        acceptButton.setLayoutX(BUTTON_X);
        int LOWER_BUTTON_Y = CLOSE_BTN_Y_POS - 24;
        acceptButton.setLayoutY(LOWER_BUTTON_Y);
        acceptButton.setOnAction(mouseEvent -> {
            try {
                city.getPlayer().getCompany().updateCash(-price);
                clientEventBus.post(new ViewChangeEvent(MainGameView.class, EDialogType.TAVERN_INFORMANT_2));
            } catch (RuntimeException e) {
                logger.error("Failed to accept informant offer", e);
            }
        });

        getContent().addAll(dt, acceptButton);
    }

    /**
     * Update the notice board and close the dialog.
     */
    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_TAVERN);
        clientEventBus.post(new NoticeBoardUpdate(proxy));
        super.executeOnCloseButtonClicked();
    }
    @Override
    public void close() {
        super.close();
        tavernDialogUtil.stopTalkingToPerson(tavernState, city.getPlayer());
    }
}
