package ch.sahits.game.openpatrician.display.dialog.tavern;

import ch.sahits.datastructure.GenericPair;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.display.dialog.service.TavernDialogUtil;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.map.MapSegmentedImage;
import ch.sahits.game.openpatrician.model.people.IInformant;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 28, 2013
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernInformantDialogPageTwo extends CloseButtonDialog {
    private final ICityPlayerProxyJFX city;
    private final IInformant informant;
    @Autowired
    private TavernDialogUtil tavernDialogUtil;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private Locale locale;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    private MessageSource messageSource;

    private final TavernState tavernState;

    public TavernInformantDialogPageTwo(ICityPlayerProxyJFX city) {
        super();
        this.city = city;
        tavernState = city.getCity().getCityState().getTavernState();
        informant =  tavernState.getInformant();
    }
    @PostConstruct
    private void initializeDialog() {


        setTitle(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernInformantDialogPageOne.title", new Object[]{informant.getName()}, locale.getCurrentLocal()));

        StringBuilder template  = new StringBuilder();
        HashMap<String, Object> parameters = new HashMap<>();
        if (informant.getWareNeeded().isPresent()) {
            GenericPair<ICity, IWare> needed = informant.getWareNeeded().get();

            template.append(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernInformantDialogPageTwo.dialog1", new Object[]{needed.getFirst().getName(), translator.getLocalDisplayName((EWare) needed.getSecond())}, locale.getCurrentLocal()));

        }
        if (informant.getWareSurplus().isPresent()) {
            GenericPair<ICity, IWare> surplus = informant.getWareSurplus().get();

            template.append(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernInformantDialogPageTwo.dialog2", new Object[]{surplus.getFirst().getName(), translator.getLocalDisplayName((EWare) surplus.getSecond())}, locale.getCurrentLocal()));
        }
        final Optional<MapSegmentedImage> mapSectionPart = informant.getMapSectionPart(city.getPlayer());
        mapSectionPart.ifPresent(mapSegmentedImage -> {
            List<Integer> visibleSegs = new ArrayList<>(mapSegmentedImage.getSegmentIndices());
            parameters.put("visibleSegments", visibleSegs);
            template.append(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernInformantDialogPageTwo.dialog4", new Object[]{mapSegmentedImage.getImageName()}, locale.getCurrentLocal()));
        });
        if (informant.getPirateLocation().isPresent()) {
            GenericPair<String, ICity> pirate = informant.getPirateLocation().get();
            template.append(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernInformantDialogPageTwo.dialog3", new Object[]{pirate.getFirst(), pirate.getSecond().getName()}, locale.getCurrentLocal()));
        }

        DecoratedText dt = decoratedTextFactory.createDecoratedText(template.toString(), parameters);

        getContent().addAll(dt);
    }

    /**
     * Update the notice board and close the dialog.
     */
    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_TAVERN);
        clientEventBus.post(new NoticeBoardUpdate(proxy));
        super.executeOnCloseButtonClicked();
    }
    @Override
    public void close() {
        super.close();
        tavernDialogUtil.stopTalkingToPerson(tavernState, city.getPlayer());
    }
}
