package ch.sahits.game.openpatrician.display.event.handler.impl;

import ch.sahits.game.openpatrician.event.data.ShipAttackEvent;
import ch.sahits.game.openpatrician.event.handler.TimedEventListener;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.people.IShipOwner;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Feb 22, 2014
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class SinkConcurrentsShipOrder  extends TimedEventListener {
    @Autowired
    @Qualifier("serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier("clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;
    @Autowired
    @XStreamOmitField
    private Locale locale;
    @Autowired
    @XStreamOmitField
    private MessageSource messageSource;

    private final IPlayer opponent;
    private final IPlayer player;
    private final int premium;
    private final TimedTask reconciliation;
    private final int offeredTime;
    @Autowired
    private TimedUpdatableTaskList list;

    public SinkConcurrentsShipOrder(IPlayer opponent,
                                    IPlayer player, int offerdTime, int premium, TimedTask reconciliation) {
        this.offeredTime = offerdTime;
        this.opponent = opponent;
        this.player = player;
        this.premium = premium;
        this.reconciliation = reconciliation;
    }
    @PostConstruct
    private void initialize() {
        if (deadline == null) {
            setDeadline(date.getCurrentDate().plusDays(offeredTime));
        }
        clientServerEventBus.register(this);
    }
    @PreDestroy
    private void unregisterEventBus() { clientServerEventBus.unregister(this);}
    /**
     * Handle the ships attak
     * @param event ship attack event
     */
    @Subscribe
    public void handleShipAttack(ShipAttackEvent event) {
        if (deadline.isAfter(date.getCurrentDate())) {
            IShipOwner attackedOwner = event.getAttackedShip().getOwner();
            IShipOwner attackingOwner = event.getAttackingShip().getOwner();
            if (attackedOwner != null && attackedOwner.equals(opponent)
                    && attackingOwner != null && attackingOwner.equals(player)) {
                execute();
                unregisterEventBus();
            }
        } else {
            destroy();
            unregisterEventBus();
        }
    }
    @Override
    public boolean execute() {
        clientEventBus.post(new DisplayMessage("ch.sahits.game.event.handler.impl.SinkConcurrentShipOrder.thankyou"));
        if (player instanceof IHumanPlayer) {
            player.getCompany().updateCash(premium);
        } else {
            player.getCompany().updateCashDirectly(premium);
        }
        if (reconciliation != null) {
            list.remove(reconciliation);
        }
        return true;
    }}
