package ch.sahits.game.openpatrician.display.gameplay.impl;

import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.javafx.MainGameView;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.google.common.eventbus.AsyncEventBus;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 13, 2013
 */
@Component
@Lazy
@DependentInitialisation(StartNewGameBean.class)
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class ShipyardScenePolygonInitializer extends ScenePolygonInitialzer {
    @Autowired
    private ClientViewState viewState;
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;

    public ShipyardScenePolygonInitializer() {
        super("images/scene/shipYard");
    }

    @Override
    protected EventHandler<MouseEvent> createEventHandler(String name) {
        try {
            switch (name) {
                case "shipYard": {
                    return arg0 -> {
                        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_SHIPYARD);
                        clientEventBus.post(new NoticeBoardUpdate(proxy));
                        clientEventBus.post(new ViewChangeEvent(MainGameView.class, proxy));
                    };
                }
                case "blacksmith": {
                    return mouseEvent -> {
                        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.MAIN_VIEW_ARMORY);
                        clientEventBus.post(new ViewChangeEvent(MainGameView.class, proxy));
                        proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.MAIN_VIEW_ARMORY);
                        clientEventBus.post(new NoticeBoardUpdate(proxy));
                    };
                }
                case "exit": {
                    return arg0 -> {
                        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.MAIN_VIEW_PORT);
                        clientEventBus.post(new ViewChangeEvent(MainGameView.class, proxy));
                        proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_HIDE);
                        clientEventBus.post(new NoticeBoardUpdate(proxy));
                    };
                }
                default:
                    throw new IllegalStateException("Unhandled polygon action: " + name);
            }
        } catch (RuntimeException e) {
            logger.error("Failed to switch to different scene: "+name, e);
            return null;
        }
    }
}
