package ch.sahits.game.openpatrician.display.javafx;

import ch.sahits.game.openpatrician.display.gameplay.impl.EScene;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardClose;
import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ObjectPropertyType;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 13, 2013
 */
@Component
@Lazy
@DependentInitialisation(StartNewGameBean.class)
@ClassCategory(EClassCategory.HANDLER)
public class TavernSceneEventHandler implements ISceneEventHandler {
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;

    @ObjectPropertyType(EScene.class)
    private ObjectProperty<EScene> currentScene = new SimpleObjectProperty<>(this, "currentScene", EScene.PORT);
    private IDialogContoller dialogContoller; // this instance exists not at startup
    @Override
    public ObjectProperty<EScene> currentSceneProperty() {
        return currentScene;
    }

    @Override
    public void setDialogContoller(IDialogContoller dialogContoller) {
        this.dialogContoller = dialogContoller;
    }

    @Override
    public void handleEvent(Object eventNotice) {
        Preconditions.checkNotNull(dialogContoller, "Dialog controller must be initialized first");
            if (eventNotice instanceof ViewChangeCityPlayerProxyJFX) {
                ViewChangeCityPlayerProxyJFX cityProxy = (ViewChangeCityPlayerProxyJFX) eventNotice;
                 // Scene change port
                if (cityProxy.getViewChangeEvent() == EViewChangeEvent.MAIN_VIEW_PORT) {
                    clientEventBus.post(new NoticeBoardClose());
                    currentScene.set(EScene.PORT);
                    dialogContoller.changeScene();
                }

            }
        if (eventNotice instanceof EDialogType) {
            dialogContoller.replaceDialog((EDialogType) eventNotice);
        }
    }
}
