package ch.sahits.game.openpatrician.display.javafx.action;

import ch.sahits.game.openpatrician.display.dialog.service.ITransferableJFX;
import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.util.HashMap;

/**
 * This proxy handles the execution of the buy action based on the current
 * type of the dialog.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 18, 2011
 *
 */
@ClassCategory(EClassCategory.HANDLER)
public class BuyJFXProxyAction implements Runnable {
	private static final Logger logger = LogManager.getLogger(BuyJFXProxyAction.class);
	private final ITransferableJFX dialog;
	@MapType(key = EDialogType.class, value = Runnable.class)
	private final HashMap<EDialogType, Runnable> actionMap;

	public BuyJFXProxyAction(IWare ware, ITransferableJFX dialog, UserActions actionFactory) {
		super();
		this.dialog = dialog;
		actionMap = new HashMap<>();
		actionMap.put(EDialogType.PORT_CITY_TO_SHIP, actionFactory.city2ShipAction(ware, dialog));
		actionMap.put(EDialogType.PORT_CITY_TO_STORAGE, actionFactory.city2StorageAction(ware,dialog));
		actionMap.put(EDialogType.PORT_STORAGE_TO_SHIP, actionFactory.ship2StorageAction(ware,dialog));
	}

	/**
	 * Delegate to the run method of the action associated with the dialog type
	 */
	@Override
	public void run() {
		try {
			Runnable action = actionMap.get(dialog.getDialogType());
			if (action==null){
                logger.error("No action defined for dialog transfer type: "+dialog.getDialogType());
            } else {
                action.run();
            }
		} catch (RuntimeException e) {
			logger.error("Failed to buy wares", e);
		}
	}

}
