package ch.sahits.game.openpatrician.display.javafx.action;


import ch.sahits.game.openpatrician.clientserverinterface.service.TradeService;
import ch.sahits.game.openpatrician.display.dialog.service.ITransferableJFX;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Optional;

/**
 * This action handles the buying of wares from the city and storing them in the storage
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 24, 2011
 *
 */
@Prototype
@ClassCategory({EClassCategory.HANDLER, EClassCategory.PROTOTYPE_BEAN})
class City2StorageJFXAction implements Runnable {
	private final IWare ware;
	private final ITransferableJFX transfer;
//	private static final Logger logger = Logger.getLogger(City2StorageAction.class);
	@Autowired
	private TradeService tradeService;

	public City2StorageJFXAction(IWare ware, ITransferableJFX transfer) {
		super();
		this.ware = ware;
		this.transfer=transfer;
	}

	@Override
	public void run() {
		int availableAmountCity = transfer.getCity().getWare(ware).getAmount();
		Optional<ITradingOffice> optOffice = transfer.getPlayer().findTradingOffice(transfer.getCity());
		if (availableAmountCity>0 && optOffice.isPresent()){
			int amount2Move = transfer.getAmount(availableAmountCity); // This is ware specific size
			tradeService.buyFromCityToStorage(optOffice.get(), transfer.getPlayer(), transfer.getCity(), ware, amount2Move, Optional.empty(), Optional.empty());
		}
	}
}
