/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog;

import ch.sahits.game.openpatrician.display.dialog.ICloseButtonDialog;
import ch.sahits.game.openpatrician.display.dialog.ParentNodeProvider;
import ch.sahits.game.openpatrician.display.javafx.MainGameView;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianSmallWaxButton;
import ch.sahits.game.openpatrician.javafx.control.PlaceHolder;
import ch.sahits.game.openpatrician.javafx.dialog.Dialog;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import java.util.ArrayList;
import java.util.Collection;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.StackPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class CloseButtonDialog
extends Dialog
implements ICloseButtonDialog {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    @Qualifier(value="clientEventBus")
    protected AsyncEventBus clientEventBus;
    @Autowired
    private ParentNodeProvider parentNodeProvider;
    private StringProperty title = new SimpleStringProperty((Object)this, "title", "");
    private StringProperty closeLabel = new SimpleStringProperty((Object)this, "closeLabel", "");
    private final OpenPatricianSmallWaxButton closeButton;

    public CloseButtonDialog() {
        Label titleLbl = new Label();
        titleLbl.getStyleClass().add((Object)"dialogTitle");
        titleLbl.textProperty().bind((ObservableValue)this.title);
        StackPane titlePane = new StackPane();
        titlePane.setLayoutY(30.0);
        titlePane.getChildren().addAll((Object[])new Node[]{new PlaceHolder(518.0, 1.0), titleLbl});
        this.getContent().add((Object)titlePane);
        this.closeButton = new OpenPatricianSmallWaxButton("X");
        this.closeButton.getStyleClass().add((Object)"closeButton");
        this.closeButton.setLayoutX(416.0);
        this.closeButton.setLayoutY(627.0);
        this.closeButton.setOnAction(event -> {
            try {
                this.executeOnCloseButtonClicked();
            }
            catch (RuntimeException e) {
                this.logger.error("Failed to close dialog", (Throwable)e);
            }
        });
        this.closeButton.getStyleClass().add((Object)"buttonLabel");
        this.getContent().add((Object)this.closeButton);
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public String getTitle() {
        return (String)this.title.get();
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    protected OpenPatricianSmallWaxButton getCloseButton() {
        return this.closeButton;
    }

    public void removeDecoratedContent() {
        ArrayList<DecoratedText> removables = new ArrayList<DecoratedText>();
        for (Node child : this.getContent()) {
            if (!(child instanceof DecoratedText)) continue;
            removables.add((DecoratedText)child);
        }
        Platform.runLater(() -> this.getContent().removeAll((Collection)removables));
    }

    public StringProperty closeLabelProperty() {
        return this.closeLabel;
    }

    public String getCloseLabel() {
        return (String)this.closeLabel.get();
    }

    public void setCloseLabel(String closeLabel) {
        this.closeLabel.set((Object)closeLabel);
    }

    public void addButtomControlButtons(OpenPatricianSmallWaxButton ... buttons) {
        double availableSpace = 376.0;
        double widthButtonAndGap = availableSpace / (double)buttons.length;
        Preconditions.checkState((widthButtonAndGap >= 62.0 ? 1 : 0) != 0, (Object)"Cannot draw buttons as there is not enough space");
        double gap = widthButtonAndGap - 62.0;
        double x = 40.0;
        for (OpenPatricianSmallWaxButton btn : buttons) {
            btn.setLayoutX(x);
            btn.setLayoutY(627.0);
            x += 62.0 + gap;
            this.getContent().add((Object)btn);
        }
    }

    public void executeOnCloseButtonClicked() {
        MainGameView mainGameView = (MainGameView)this.parentNodeProvider.getParent((Node)this);
        if (mainGameView != null) {
            mainGameView.closeDialog();
        }
    }
}

