/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.armory;

import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.dialog.TabelViewDialog;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.IViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianSmallWaxButton;
import ch.sahits.game.openpatrician.javafx.model.ControlTableCell;
import ch.sahits.game.openpatrician.javafx.model.DynamicTextTableCell;
import ch.sahits.game.openpatrician.javafx.model.ITableCell;
import ch.sahits.game.openpatrician.javafx.model.StaticTextTableCell;
import ch.sahits.game.openpatrician.javafx.model.Table;
import ch.sahits.game.openpatrician.javafx.model.TableHeader;
import ch.sahits.game.openpatrician.javafx.model.TableRow;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.building.IWeaponStorage;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.javafx.bindings.StaticIntegerBinding;
import ch.sahits.game.openpatrician.model.product.ComputablePriceV2;
import ch.sahits.game.openpatrician.model.product.ETransferAmount;
import ch.sahits.game.openpatrician.model.product.ITradable;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.model.service.TransferUtil;
import ch.sahits.game.openpatrician.model.weapon.ArmoryRegistry;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.model.weapon.IArmory;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class ShipWeaponDialog
extends TabelViewDialog {
    private static final int IMAGE_DIM = 60;
    private final ICityPlayerProxyJFX city;
    private IArmory armory;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @Autowired
    private IDataImageLoader imageLoader;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    private TransferUtil transferUtil;
    @Autowired
    private ComputablePriceV2 computablePrice;
    @Autowired
    private ArmoryRegistry registry;
    @Autowired
    private ClientViewState viewState;

    public ShipWeaponDialog(ICityPlayerProxyJFX city) {
        this.city = city;
    }

    @PostConstruct
    private void initializeDialog() {
        this.armory = this.registry.getArmory(this.city.getCity());
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.armory.ShipWeaponDialog.title", new Object[0], this.locale.getCurrentLocal()));
        Table model = this.createModel(this.city);
        this.setModel(model);
    }

    private Table createModel(ICityPlayerProxyJFX cityProxy) {
        Table model = new Table();
        TableHeader header = new TableHeader(6);
        header.add((ITableCell)new StaticTextTableCell(""));
        header.add((ITableCell)new StaticTextTableCell(""));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.armory.ShipWeaponDialog.header.amrory", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.armory.ShipWeaponDialog.header.buy", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.armory.ShipWeaponDialog.header.sell", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.armory.ShipWeaponDialog.header.tradingOffice", new Object[0], this.locale.getCurrentLocal())));
        header.setAligenment(0, HPos.RIGHT);
        header.setAligenment(1, HPos.RIGHT);
        header.setAligenment(2, HPos.RIGHT);
        header.setAligenment(3, HPos.CENTER);
        header.setAligenment(4, HPos.CENTER);
        header.setAligenment(5, HPos.CENTER);
        model.setHeader(header);
        model.setAligenment(0, HPos.LEFT);
        model.setAligenment(1, HPos.LEFT);
        model.setAligenment(2, HPos.RIGHT);
        model.setAligenment(3, HPos.CENTER);
        model.setAligenment(4, HPos.CENTER);
        model.setAligenment(5, HPos.CENTER);
        model.setColumnWidth(new Integer[]{130, 40, 72, 72, 60, 70});
        ICity city = cityProxy.getCity();
        Optional optOffice = cityProxy.getPlayer().findTradingOffice(city);
        if (!optOffice.isPresent()) {
            throw new IllegalStateException("This dialog should only be available if player has trading office in city.");
        }
        ITradingOffice office = (ITradingOffice)optOffice.get();
        IWeaponStorage weaponStorage = office.getWeaponStorage();
        model.add(this.addWeaponRow(weaponStorage, EWeapon.HAND_WEAPON));
        model.add(this.addWeaponRow(weaponStorage, EWeapon.TREBUCHET_SMALL));
        model.add(this.addWeaponRow(weaponStorage, EWeapon.BALLISTA_SMALL));
        model.add(this.addWeaponRow(weaponStorage, EWeapon.TREBUCHET_BIG));
        model.add(this.addWeaponRow(weaponStorage, EWeapon.BALLISTA_BIG));
        model.add(this.addWeaponRow(weaponStorage, EWeapon.BOMBARD));
        model.add(this.addWeaponRow(weaponStorage, EWeapon.CANNON));
        return model;
    }

    private TableRow addWeaponRow(IWeaponStorage weaponStorage, EWeapon weapon) {
        TableRow row = new TableRow();
        row.setHeigth(60);
        row.add((ITableCell)new StaticTextTableCell(this.translator.getLocalDisplayName(weapon)));
        Image img = this.imageLoader.getImage(this.getWeaponImageName(weapon), 60.0, 60.0);
        ImageView imgView = new ImageView(img);
        row.add((ITableCell)new ControlTableCell((Node)imgView));
        DynamicTextTableCell weaponAmountInArmory = new DynamicTextTableCell();
        weaponAmountInArmory.valueProperty().bind((ObservableValue)this.getAmountInArmoryAsStringBinding(weapon));
        row.add((ITableCell)weaponAmountInArmory);
        IntegerBinding weaponBuyPrice = this.buyPriceBinding(weapon);
        OpenPatricianSmallWaxButton weaponBuyBtn = new OpenPatricianSmallWaxButton("");
        weaponBuyBtn.disableProperty().bind((ObservableValue)this.getAmountInArmory(weapon).greaterThan(0).not());
        weaponBuyBtn.setId("buyWeapon" + weapon);
        weaponBuyBtn.textProperty().bind((ObservableValue)weaponBuyPrice.asString());
        row.add((ITableCell)new ControlTableCell((Node)weaponBuyBtn));
        weaponBuyBtn.setOnAction(evt -> {
            if (!weaponBuyBtn.isDisable()) {
                IHumanPlayer player = this.city.getPlayer();
                ICompany company = player.getCompany();
                this.reduceStoredAmount(weapon);
                weaponStorage.update((IWeapon)weapon, 1);
                int price = weaponBuyPrice.get();
                company.updateCash((long)(-price));
            }
        });
        IntegerBinding weaponSellPrice = this.sellPriceBinding(weapon);
        OpenPatricianSmallWaxButton weaponSellBtn = new OpenPatricianSmallWaxButton("");
        weaponSellBtn.disableProperty().bind((ObservableValue)weaponStorage.getWeaponProperty((IWeapon)weapon).greaterThan(0).not());
        weaponSellBtn.setId("sellWeapon" + weapon);
        weaponSellBtn.textProperty().bind((ObservableValue)weaponSellPrice.asString());
        row.add((ITableCell)new ControlTableCell((Node)weaponSellBtn));
        weaponSellBtn.setOnAction(evt -> {
            if (!weaponSellBtn.isDisable()) {
                IHumanPlayer player = this.city.getPlayer();
                ICompany company = player.getCompany();
                this.increaseStoredAmount(weapon);
                weaponStorage.update((IWeapon)weapon, -1);
                int price = weaponSellPrice.get();
                company.updateCash((long)price);
            }
        });
        DynamicTextTableCell weaponsInStorage = new DynamicTextTableCell();
        weaponsInStorage.valueProperty().bind((ObservableValue)weaponStorage.getWeaponProperty((IWeapon)weapon).asString());
        row.add((ITableCell)weaponsInStorage);
        return row;
    }

    private StringBinding getAmountInArmoryAsStringBinding(final EWeapon weapon) {
        return new StringBinding(){
            {
                super.bind(new Observable[]{ShipWeaponDialog.this.getAmountInArmory(weapon)});
            }

            protected String computeValue() {
                ReadOnlyIntegerProperty amountInArmory = ShipWeaponDialog.this.getAmountInArmory(weapon);
                return String.valueOf(amountInArmory.getValue());
            }
        };
    }

    private void reduceStoredAmount(EWeapon weapon) {
        this.updateWeaponAmount(weapon, -1);
    }

    private void increaseStoredAmount(EWeapon weapon) {
        this.updateWeaponAmount(weapon, 1);
    }

    private void updateWeaponAmount(EWeapon weapon, int delta) {
        switch (weapon) {
            case HAND_WEAPON: {
                this.armory.updateCutlassAmount(delta);
                break;
            }
            case BALLISTA_BIG: {
                this.armory.updateBallistaBigAmount(delta);
                break;
            }
            case BALLISTA_SMALL: {
                this.armory.updateBallistaSmallAmount(delta);
                break;
            }
            case TREBUCHET_BIG: {
                this.armory.updateTrebuchetBigAmount(delta);
                break;
            }
            case TREBUCHET_SMALL: {
                this.armory.updateTrebuchetSmallAmount(delta);
                break;
            }
            case BOMBARD: {
                this.armory.updateBombardAmount(delta);
                break;
            }
            case CANNON: {
                this.armory.updateCanonAmount(delta);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled weapon type: " + weapon);
            }
        }
    }

    private String getWeaponImageName(EWeapon weapon) {
        switch (weapon) {
            case HAND_WEAPON: {
                return "images/Cutlass";
            }
            case BALLISTA_BIG: {
                return "images/Ballista_big";
            }
            case BALLISTA_SMALL: {
                return "images/Ballista_small";
            }
            case TREBUCHET_BIG: {
                return "images/Trebuchet_big";
            }
            case TREBUCHET_SMALL: {
                return "images/Trebuchet_small";
            }
            case BOMBARD: {
                return "images/Bombard";
            }
            case CANNON: {
                return "images/Cannon";
            }
        }
        throw new IllegalArgumentException("Unhandled weapon type: " + weapon);
    }

    private ReadOnlyIntegerProperty getAmountInArmory(EWeapon weapon) {
        switch (weapon) {
            case HAND_WEAPON: {
                return this.armory.cutlassAmountProperty();
            }
            case BALLISTA_BIG: {
                return this.armory.ballistaBigAmountProperty();
            }
            case BALLISTA_SMALL: {
                return this.armory.ballistaSmallAmountProperty();
            }
            case TREBUCHET_BIG: {
                return this.armory.trebuchetBigAmountProperty();
            }
            case TREBUCHET_SMALL: {
                return this.armory.ballistaSmallAmountProperty();
            }
            case BOMBARD: {
                return this.armory.bombardAmountProperty();
            }
            case CANNON: {
                return this.armory.canonAmountProperty();
            }
        }
        throw new IllegalArgumentException("Unhandled weapon type: " + weapon);
    }

    private IntegerBinding buyPriceBinding(final EWeapon weapon) {
        return new IntegerBinding(){
            {
                super.bind(new Observable[]{ShipWeaponDialog.this.getAmountInArmory(weapon)});
            }

            protected int computeValue() {
                int availableAmount = ShipWeaponDialog.this.getAmountInArmory(weapon).get();
                int buyAmount = ShipWeaponDialog.this.transferUtil.calculateAvailableAmount(ETransferAmount.ONE, availableAmount);
                if (buyAmount > 0) {
                    return ShipWeaponDialog.this.computablePrice.buyPrice((ITradable)weapon, (ReadOnlyIntegerProperty)new SimpleIntegerProperty(availableAmount), (IntegerBinding)new StaticIntegerBinding(buyAmount)) * 2;
                }
                return 0;
            }
        };
    }

    private IntegerBinding sellPriceBinding(final EWeapon weapon) {
        return new IntegerBinding(){
            {
                super.bind(new Observable[]{ShipWeaponDialog.this.getAmountInArmory(weapon)});
            }

            protected int computeValue() {
                int availableAmount = ShipWeaponDialog.this.getAmountInArmory(weapon).get();
                int buyAmount = ShipWeaponDialog.this.transferUtil.calculateAvailableAmount(ETransferAmount.ONE, availableAmount);
                if (buyAmount > 0) {
                    return ShipWeaponDialog.this.computablePrice.sellPrice((ITradable)weapon, (ReadOnlyIntegerProperty)new SimpleIntegerProperty(availableAmount), (IntegerBinding)new StaticIntegerBinding(buyAmount)) * 2;
                }
                return 0;
            }
        };
    }

    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.MAIN_VIEW_ARMORY);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }
}

