/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.church;

import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.graphic.image.IFontLoader;
import ch.sahits.game.graphic.image.impl.SelectiveCachableXMLImageLoader;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.IViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.control.MoneyTransfer;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.javafx.service.JavaFXUtils;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import java.util.HashMap;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class ChurchGiftDialog
extends CloseButtonDialog {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final ICityPlayerProxyJFX city;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @Autowired
    @Qualifier(value="xmlImageLoader")
    private SelectiveCachableXMLImageLoader imageLoader;
    @Autowired
    private JavaFXUtils fxUtils;
    @Autowired
    private IFontLoader fontLoader;
    @Autowired
    private DecoratedTextFactory textFactory;
    private MoneyTransfer moneyTransfer;

    public ChurchGiftDialog(ICityPlayerProxyJFX city) {
        this.city = city;
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.church.ChurchGiftDialog.title", new Object[0], this.locale.getCurrentLocal()));
        String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.church.ChurchGiftDialog.introText", new Object[0], this.locale.getCurrentLocal());
        DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
        VBox box = new VBox(new Node[]{text});
        ICompany company = this.city.getPlayer().getCompany();
        this.moneyTransfer = this.fxUtils.getMoneyTransfer((IDataImageLoader)this.imageLoader);
        this.moneyTransfer.setStepSize(500);
        this.moneyTransfer.maxTransfereableProperty().bind((ObservableValue)company.cashProperty());
        this.moneyTransfer.setAmount(0);
        box.setLayoutX(50.0);
        box.setLayoutY(127.0);
        this.moneyTransfer.setPadding(new Insets(100.0, 0.0, 0.0, 100.0));
        box.getChildren().addAll((Object[])new Node[]{this.moneyTransfer});
        int actionButtonX = 197;
        String s = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.church.ChurchFeedingDialog.donate", new Object[0], this.locale.getCurrentLocal());
        OpenPatricianLargeWaxButton action = new OpenPatricianLargeWaxButton(s);
        action.getStyleClass().add((Object)"actionButton");
        action.setOnAction(this.getAction());
        action.setLayoutX(197.0);
        action.setLayoutY(603.0);
        BooleanBinding actionEnabled = this.actionEnabledBinding();
        action.setDisable(!actionEnabled.get());
        actionEnabled.addListener((observableValue, oldValue, newValue) -> action.setDisable(newValue == false));
        this.getContent().addAll((Object[])new Node[]{box, action});
    }

    private BooleanBinding actionEnabledBinding() {
        return new BooleanBinding(){

            protected boolean computeValue() {
                return ChurchGiftDialog.this.moneyTransfer.getAmount() > 0;
            }
        };
    }

    private EventHandler<MouseEvent> getAction() {
        return evt -> {
            try {
                ICompany company = this.city.getPlayer().getCompany();
                company.updateCash((long)(-this.moneyTransfer.getAmount()));
                this.city.getCity().getReputation((IPlayer)this.city.getPlayer()).update(this.moneyTransfer.getAmount() / 1000);
                this.executeOnCloseButtonClicked();
            }
            catch (RuntimeException e) {
                this.logger.error("Failed to make a donation to the city", (Throwable)e);
            }
        };
    }

    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.MAIN_VIEW_CHURCH);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }
}

