/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.cityhall;

import ch.sahits.game.graphic.image.impl.SelectiveCachableXMLImageLoader;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.ModelStateAccessor;
import ch.sahits.game.openpatrician.clientserverinterface.service.OutriggerService;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.display.dialog.service.DialogUtil;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.IViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.javafx.service.JavaFXUtils;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityHall;
import ch.sahits.game.openpatrician.model.city.cityhall.IOutriggerContract;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.OutriggerContract;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class OutriggerNoticeDialog
extends CloseButtonDialog {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @ObjectPropertyType(value=IShip.class)
    private final ObjectProperty<IShip> currentShip;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private ModelStateAccessor cityHallAccessor;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private OutriggerService outriggerService;
    @Autowired
    private ShipService shipService;
    @Autowired
    private ModelTranslations modelTranslator;
    @Autowired
    @Qualifier(value="xmlImageLoader")
    private SelectiveCachableXMLImageLoader imageLoader;
    @Autowired
    private JavaFXUtils fxUtils;
    @Autowired
    private DialogUtil dialogUtil;
    @ListType(value=IShip.class)
    private ObservableList<IShip> capableShips;
    private ListChangeListener<IShip> availableShipChangeListener;
    private final IntegerProperty currentIndex = new SimpleIntegerProperty(0);
    private BooleanBinding capableShipPresent;
    private final ICityPlayerProxyJFX city;
    private StyleableObjectProperty<Font> font;

    public OutriggerNoticeDialog(final ICityPlayerProxyJFX city) {
        this.city = city;
        this.getStylesheets().add((Object)this.getClass().getResource("/styles/base.css").toExternalForm());
        this.getStyleClass().add((Object)"dialog");
        this.capableShipPresent = new BooleanBinding(){
            {
                super.bind(new Observable[]{city.getPlayersShips()});
            }

            protected boolean computeValue() {
                return !OutriggerNoticeDialog.this.getCapableShips().isEmpty();
            }
        };
        this.capableShips = FXCollections.observableArrayList();
        this.availableShipChangeListener = c -> this.capableShips.setAll(this.getCapableShips());
        city.getPlayersShips().addListener((ListChangeListener)new WeakListChangeListener(this.availableShipChangeListener));
        this.capableShips.addListener((ListChangeListener)new ListChangeListener<IShip>(){

            public void onChanged(ListChangeListener.Change<? extends IShip> c) {
                if (OutriggerNoticeDialog.this.capableShips.size() <= OutriggerNoticeDialog.this.currentIndex.get()) {
                    OutriggerNoticeDialog.this.currentIndex.setValue((Number)(OutriggerNoticeDialog.this.capableShips.size() - 1));
                }
            }
        });
        this.currentShip = new SimpleObjectProperty((Object)this, "currentShip", null);
        if (city.getActiveShip() instanceof IShip) {
            this.currentShip.setValue((Object)((IShip)city.getActiveShip()));
        }
    }

    private List<IShip> getCapableShips() {
        int minWeaponStrength = this.outriggerService.getRequiredWeaponStrength(this.city.getCity());
        ArrayList<IShip> ships = new ArrayList<IShip>();
        for (IShip ship : this.city.getPlayersShips()) {
            if (!ship.getCaptian().isPresent() || ship.getNumberOfSailors() < 20 || ship.getDamage() >= 50 || this.shipService.calculateShipsWeaponsStrength((INavigableVessel)ship) < minWeaponStrength) continue;
            ships.add(ship);
        }
        return ships;
    }

    @PostConstruct
    private void initializeDialog() {
        this.capableShips.setAll(this.getCapableShips());
        ICityHall cityHall = this.cityHallAccessor.getCityHall(this.city.getCity());
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.cityHallOutriggerNotice", new Object[0], this.locale.getCurrentLocal()));
        int actionButtonX = 197;
        if (cityHall.getOutriggerContract().isPresent()) {
            String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.OutriggerNoticeDialog.outriggerPresent", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal());
            DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
            this.getContent().add((Object)text);
            DecoratedText prevText = text;
            IOutriggerContract contract = (IOutriggerContract)cityHall.getOutriggerContract().get();
            IShip ship = contract.getOutrigger();
            IPlayer owner = (IPlayer)ship.getOwner();
            Object[] args = new Object[]{this.modelTranslator.getLocalDisplayNameWithArticle(ship.getShipType(), true), ship.getName(), this.modelTranslator.getLocalDisplayName(owner.getCareerLevel()), this.modelTranslator.getLocalDisplayName(owner.getRank()), owner.getName() + " " + owner.getLastName()};
            template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.OutriggerNoticeDialog.outriggerOwner", args, this.locale.getCurrentLocal());
            text = this.textFactory.createDecoratedText(template, new HashMap());
            text.layoutYProperty().bind((ObservableValue)prevText.heightProperty().add((ObservableNumberValue)prevText.layoutYProperty()).add(24));
            this.getContent().add((Object)text);
            GridPane grid = this.dialogUtil.createShipSelection3LinesForShips(this.capableShips, this.currentShip);
            grid.getStyleClass().add((Object)"tableFont");
            grid.setLayoutX(100.0);
            grid.setLayoutY(227.0);
            this.getContent().add((Object)grid);
            template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.OutriggerNoticeDialog.weeklyRefund", new Object[]{ship.getName(), contract.getWeeklyRefund()}, this.locale.getCurrentLocal());
            text = this.textFactory.createDecoratedText(template, new HashMap());
            text.setLayoutY(427.0);
            this.getContent().add((Object)text);
            OpenPatricianLargeWaxButton action = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.OutriggerNoticeDialog.discharge", new Object[0], this.locale.getCurrentLocal()));
            action.getStyleClass().add((Object)"actionButton");
            action.setOnAction(this.getAction(contract));
            action.setLayoutX(197.0);
            action.setLayoutY(603.0);
            action.setDisable(!this.capableShipPresent.get());
            this.getContent().addAll((Object[])new Node[]{action});
        } else {
            int minStrength = this.outriggerService.getRequiredWeaponStrength(this.city.getCity());
            int refund = this.outriggerService.getWeeklyReund(this.city.getCity());
            String key = null;
            key = minStrength % 2 != 0 ? (minStrength == 1 ? "ch.sahits.game.openpatrician.display.dialog.cityhall.OutriggerNoticeDialog.outriggerRequestOne" : "ch.sahits.game.openpatrician.display.dialog.cityhall.OutriggerNoticeDialog.outriggerRequestUneven") : "ch.sahits.game.openpatrician.display.dialog.cityhall.OutriggerNoticeDialog.outriggerRequestEven";
            String template = this.messageSource.getMessage(key, new Object[]{this.city.getCity().getName(), minStrength / 2, refund}, this.locale.getCurrentLocal());
            DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
            this.getContent().add((Object)text);
            if (!this.capableShipPresent.get()) {
                template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.OutriggerNoticeDialog.noShip", new Object[0], this.locale.getCurrentLocal());
                text = this.textFactory.createDecoratedText(template, new HashMap());
                text.setLayoutY(227.0);
                this.getContent().add((Object)text);
            } else {
                GridPane grid = this.dialogUtil.createShipSelection3LinesForShips(this.capableShips, this.currentShip);
                grid.getStyleClass().add((Object)"tableFont");
                grid.setLayoutX(100.0);
                grid.setLayoutY(227.0);
                this.getContent().add((Object)grid);
            }
            OpenPatricianLargeWaxButton action = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernBaseSideRoomPersonDialog.accept", new Object[0], this.locale.getCurrentLocal()));
            action.getStyleClass().add((Object)"actionButton");
            action.setOnAction(this.getAction(minStrength, refund));
            action.setLayoutX(197.0);
            action.setLayoutY(603.0);
            action.setDisable(!this.capableShipPresent.get());
            this.capableShipPresent.addListener((observable, oldFlag, newFlag) -> action.setDisable(newFlag == false));
            this.getContent().addAll((Object[])new Node[]{action});
        }
    }

    private EventHandler<MouseEvent> getAction(IOutriggerContract contract) {
        return mouseEvent -> {
            try {
                IShip ship = contract.getOutrigger();
                ship.setAvailable(true);
                this.city.getPlayersShips().add((Object)ship);
                this.cityHallAccessor.getCityHall(this.city.getCity()).setOutriggerContract(Optional.empty());
                this.executeOnCloseButtonClicked();
            }
            catch (RuntimeException e) {
                this.logger.error("Failed to switch outrigger", (Throwable)e);
            }
        };
    }

    private EventHandler<MouseEvent> getAction(int minStrength, int refund) {
        return mouseEvent -> {
            try {
                IShip ship = (IShip)this.currentShip.get();
                OutriggerContract contract = new OutriggerContract(ship, minStrength, refund);
                ship.setAvailable(false);
                this.city.getPlayersShips().remove((Object)ship);
                Optional<OutriggerContract> optContract = Optional.of(contract);
                this.cityHallAccessor.getCityHall(this.city.getCity()).setOutriggerContract(optContract);
                this.executeOnCloseButtonClicked();
            }
            catch (RuntimeException e) {
                this.logger.error("Failed to switch outrigger", (Throwable)e);
            }
        };
    }

    private EventHandler<MouseEvent> createNextAction() {
        return mouseEvent -> {
            try {
                if (this.currentIndex.get() == this.capableShips.size() - 1) {
                    this.currentIndex.set(0);
                } else {
                    this.currentIndex.set(this.currentIndex.get() + 1);
                }
            }
            catch (RuntimeException e) {
                this.logger.error("Failed to switch outrigger", (Throwable)e);
            }
        };
    }

    private EventHandler<MouseEvent> createPreviousAction() {
        return mouseEvent -> {
            try {
                if (this.currentIndex.get() == 0) {
                    this.currentIndex.set(this.capableShips.size() - 1);
                } else {
                    this.currentIndex.set(this.currentIndex.get() - 1);
                }
            }
            catch (RuntimeException e) {
                this.logger.error("Failed to switch to previous ship", (Throwable)e);
            }
        };
    }

    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_CITY_HALL_BOARD);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }

    public Font getFont() {
        return this.font == null ? Font.getDefault() : (Font)this.font.get();
    }

    public void setFont(Font font) {
        this.font.set((Object)font);
    }

    public StyleableObjectProperty<Font> fontProperty() {
        if (this.font == null) {
            this.font = new SimpleStyleableObjectProperty(StyleableProperties.FONT, (Object)this, "font", (Object)Font.getDefault());
        }
        return this.font;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return OutriggerNoticeDialog.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<OutriggerNoticeDialog, Font> FONT = new CssMetaData<OutriggerNoticeDialog, Font>("-fx-font", StyleConverter.getFontConverter(), Font.getDefault()){

            public boolean isSettable(OutriggerNoticeDialog control) {
                return control.font == null || !control.font.isBound();
            }

            public StyleableProperty<Font> getStyleableProperty(OutriggerNoticeDialog control) {
                return control.fontProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, FONT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

