/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.ship;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.display.dialog.service.DialogUtil;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class ShipInfoDialog
extends CloseButtonDialog {
    private final ICityPlayerProxyJFX proxy;
    @Autowired
    private DialogUtil dialogUtil;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;

    public ShipInfoDialog(ICityPlayerProxyJFX proxy) {
        this.proxy = proxy;
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.ship.ShipInfoDialog.title", new Object[0], this.locale.getCurrentLocal()));
        SimpleObjectProperty shipProperty = new SimpleObjectProperty((Object)((IShip)this.proxy.getActiveShip()));
        ObjectBinding<IShip> shipBinding = this.shipBinding();
        shipProperty.bind(shipBinding);
        GridPane shipInfo = this.dialogUtil.createShipInfoOnThreeLines((ObjectProperty<IShip>)shipProperty);
        shipInfo.setId("shipInfo");
        shipInfo.setLayoutY(100.0);
        shipInfo.setLayoutX(30.0);
        Pane weaponPane = this.dialogUtil.createShipWeaponDisplay((IShip)shipProperty.get());
        weaponPane.setId("weaponPane");
        weaponPane.setScaleX(0.5);
        weaponPane.setScaleY(0.5);
        weaponPane.setLayoutX(-240.0);
        weaponPane.setLayoutY(100.0);
        shipBinding.addListener((observable, oldValue, newValue) -> {
            this.getContent().remove(this.getContent().size() - 1);
            Pane pane = this.dialogUtil.createShipWeaponDisplay((IShip)newValue);
            pane.setId("weaponPane");
            pane.setScaleX(0.5);
            pane.setScaleY(0.5);
            pane.setLayoutX(-240.0);
            pane.setLayoutY(100.0);
            this.getContent().add((Object)pane);
        });
        this.getContent().addAll((Object[])new Node[]{shipInfo, weaponPane});
    }

    private ObjectBinding<IShip> shipBinding() {
        return new ObjectBinding<IShip>(){

            protected IShip computeValue() {
                INavigableVessel vessel = ShipInfoDialog.this.proxy.getActiveShip();
                if (vessel instanceof IShip) {
                    return (IShip)vessel;
                }
                ShipInfoDialog.this.executeOnCloseButtonClicked();
                return null;
            }
        };
    }
}

